/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(VirtualGatewayData.getter(VirtualGatewayData::meshName)).setter(VirtualGatewayData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(VirtualGatewayData.getter(VirtualGatewayData::metadata)).setter(VirtualGatewayData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<VirtualGatewaySpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(VirtualGatewayData.getter(VirtualGatewayData::spec)).setter(VirtualGatewayData.setter(Builder::spec)).constructor(VirtualGatewaySpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<VirtualGatewayStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(VirtualGatewayData.getter(VirtualGatewayData::status)).setter(VirtualGatewayData.setter(Builder::status)).constructor(VirtualGatewayStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayName").getter(VirtualGatewayData.getter(VirtualGatewayData::virtualGatewayName)).setter(VirtualGatewayData.setter(Builder::virtualGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final VirtualGatewaySpec spec;
    private final VirtualGatewayStatus status;
    private final String virtualGatewayName;

    private VirtualGatewayData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    public String meshName() {
        return this.meshName;
    }

    public ResourceMetadata metadata() {
        return this.metadata;
    }

    public VirtualGatewaySpec spec() {
        return this.spec;
    }

    public VirtualGatewayStatus status() {
        return this.status;
    }

    public String virtualGatewayName() {
        return this.virtualGatewayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayData)) {
            return false;
        }
        VirtualGatewayData other = (VirtualGatewayData)obj;
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.virtualGatewayName(), other.virtualGatewayName());
    }

    public String toString() {
        return ToString.builder((String)"VirtualGatewayData").add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).add("VirtualGatewayName", (Object)this.virtualGatewayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "virtualGatewayName": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayData, T> g) {
        return obj -> g.apply((VirtualGatewayData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meshName;
        private ResourceMetadata metadata;
        private VirtualGatewaySpec spec;
        private VirtualGatewayStatus status;
        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayData model) {
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.spec(model.spec);
            this.status(model.status);
            this.virtualGatewayName(model.virtualGatewayName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final VirtualGatewaySpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualGatewaySpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualGatewaySpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final VirtualGatewayStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(VirtualGatewayStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VirtualGatewayStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        public VirtualGatewayData build() {
            return new VirtualGatewayData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayData> {
        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder spec(VirtualGatewaySpec var1);

        default public Builder spec(Consumer<VirtualGatewaySpec.Builder> spec) {
            return this.spec((VirtualGatewaySpec)((VirtualGatewaySpec.Builder)VirtualGatewaySpec.builder().applyMutation(spec)).build());
        }

        public Builder status(VirtualGatewayStatus var1);

        default public Builder status(Consumer<VirtualGatewayStatus.Builder> status) {
            return this.status((VirtualGatewayStatus)((VirtualGatewayStatus.Builder)VirtualGatewayStatus.builder().applyMutation(status)).build());
        }

        public Builder virtualGatewayName(String var1);
    }
}

