/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.CertificateAuthorityArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TlsValidationContextAcmTrust
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TlsValidationContextAcmTrust> {
    private static final SdkField<List<String>> CERTIFICATE_AUTHORITY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateAuthorityArns").getter(TlsValidationContextAcmTrust.getter(TlsValidationContextAcmTrust::certificateAuthorityArns)).setter(TlsValidationContextAcmTrust.setter(Builder::certificateAuthorityArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthorityArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> certificateAuthorityArns;

    private TlsValidationContextAcmTrust(BuilderImpl builder) {
        this.certificateAuthorityArns = builder.certificateAuthorityArns;
    }

    public boolean hasCertificateAuthorityArns() {
        return this.certificateAuthorityArns != null && !(this.certificateAuthorityArns instanceof SdkAutoConstructList);
    }

    public List<String> certificateAuthorityArns() {
        return this.certificateAuthorityArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateAuthorityArns() ? this.certificateAuthorityArns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsValidationContextAcmTrust)) {
            return false;
        }
        TlsValidationContextAcmTrust other = (TlsValidationContextAcmTrust)obj;
        return this.hasCertificateAuthorityArns() == other.hasCertificateAuthorityArns() && Objects.equals(this.certificateAuthorityArns(), other.certificateAuthorityArns());
    }

    public String toString() {
        return ToString.builder((String)"TlsValidationContextAcmTrust").add("CertificateAuthorityArns", this.hasCertificateAuthorityArns() ? this.certificateAuthorityArns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateAuthorityArns": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsValidationContextAcmTrust, T> g) {
        return obj -> g.apply((TlsValidationContextAcmTrust)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> certificateAuthorityArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TlsValidationContextAcmTrust model) {
            this.certificateAuthorityArns(model.certificateAuthorityArns);
        }

        public final Collection<String> getCertificateAuthorityArns() {
            if (this.certificateAuthorityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateAuthorityArns;
        }

        @Override
        public final Builder certificateAuthorityArns(Collection<String> certificateAuthorityArns) {
            this.certificateAuthorityArns = CertificateAuthorityArnsCopier.copy(certificateAuthorityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorityArns(String ... certificateAuthorityArns) {
            this.certificateAuthorityArns(Arrays.asList(certificateAuthorityArns));
            return this;
        }

        public final void setCertificateAuthorityArns(Collection<String> certificateAuthorityArns) {
            this.certificateAuthorityArns = CertificateAuthorityArnsCopier.copy(certificateAuthorityArns);
        }

        public TlsValidationContextAcmTrust build() {
            return new TlsValidationContextAcmTrust(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TlsValidationContextAcmTrust> {
        public Builder certificateAuthorityArns(Collection<String> var1);

        public Builder certificateAuthorityArns(String ... var1);
    }
}

