/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshResponse;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteListCopier;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGatewayRoutesResponse
extends AppMeshResponse
implements ToCopyableBuilder<Builder, ListGatewayRoutesResponse> {
    private static final SdkField<List<GatewayRouteRef>> GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("gatewayRoutes").getter(ListGatewayRoutesResponse.getter(ListGatewayRoutesResponse::gatewayRoutes)).setter(ListGatewayRoutesResponse.setter(Builder::gatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayRouteRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGatewayRoutesResponse.getter(ListGatewayRoutesResponse::nextToken)).setter(ListGatewayRoutesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTES_FIELD, NEXT_TOKEN_FIELD));
    private final List<GatewayRouteRef> gatewayRoutes;
    private final String nextToken;

    private ListGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayRoutes = builder.gatewayRoutes;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGatewayRoutes() {
        return this.gatewayRoutes != null && !(this.gatewayRoutes instanceof SdkAutoConstructList);
    }

    public List<GatewayRouteRef> gatewayRoutes() {
        return this.gatewayRoutes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayRoutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewayRoutesResponse)) {
            return false;
        }
        ListGatewayRoutesResponse other = (ListGatewayRoutesResponse)((Object)obj);
        return Objects.equals(this.gatewayRoutes(), other.gatewayRoutes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGatewayRoutesResponse").add("GatewayRoutes", this.gatewayRoutes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.gatewayRoutes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewayRoutesResponse, T> g) {
        return obj -> g.apply((ListGatewayRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshResponse.BuilderImpl
    implements Builder {
        private List<GatewayRouteRef> gatewayRoutes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewayRoutesResponse model) {
            super(model);
            this.gatewayRoutes(model.gatewayRoutes);
            this.nextToken(model.nextToken);
        }

        public final Collection<GatewayRouteRef.Builder> getGatewayRoutes() {
            return this.gatewayRoutes != null ? (Collection)this.gatewayRoutes.stream().map(GatewayRouteRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayRoutes(Collection<GatewayRouteRef> gatewayRoutes) {
            this.gatewayRoutes = GatewayRouteListCopier.copy(gatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayRoutes(GatewayRouteRef ... gatewayRoutes) {
            this.gatewayRoutes(Arrays.asList(gatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayRoutes(Consumer<GatewayRouteRef.Builder> ... gatewayRoutes) {
            this.gatewayRoutes(Stream.of(gatewayRoutes).map(c -> (GatewayRouteRef)((GatewayRouteRef.Builder)GatewayRouteRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayRoutes(Collection<GatewayRouteRef.BuilderImpl> gatewayRoutes) {
            this.gatewayRoutes = GatewayRouteListCopier.copyFromBuilder(gatewayRoutes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewayRoutesResponse build() {
            return new ListGatewayRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGatewayRoutesResponse> {
        public Builder gatewayRoutes(Collection<GatewayRouteRef> var1);

        public Builder gatewayRoutes(GatewayRouteRef ... var1);

        public Builder gatewayRoutes(Consumer<GatewayRouteRef.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

