/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.PortSetCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayClientPolicyTls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayClientPolicyTls> {
    private static final SdkField<Boolean> ENFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::enforce)).setter(VirtualGatewayClientPolicyTls.setter(Builder::enforce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforce").build()}).build();
    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::ports)).setter(VirtualGatewayClientPolicyTls.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VirtualGatewayTlsValidationContext> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::validation)).setter(VirtualGatewayClientPolicyTls.setter(Builder::validation)).constructor(VirtualGatewayTlsValidationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_FIELD, PORTS_FIELD, VALIDATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enforce;
    private final List<Integer> ports;
    private final VirtualGatewayTlsValidationContext validation;

    private VirtualGatewayClientPolicyTls(BuilderImpl builder) {
        this.enforce = builder.enforce;
        this.ports = builder.ports;
        this.validation = builder.validation;
    }

    public Boolean enforce() {
        return this.enforce;
    }

    public boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public List<Integer> ports() {
        return this.ports;
    }

    public VirtualGatewayTlsValidationContext validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.ports());
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayClientPolicyTls)) {
            return false;
        }
        VirtualGatewayClientPolicyTls other = (VirtualGatewayClientPolicyTls)obj;
        return Objects.equals(this.enforce(), other.enforce()) && Objects.equals(this.ports(), other.ports()) && Objects.equals(this.validation(), other.validation());
    }

    public String toString() {
        return ToString.builder((String)"VirtualGatewayClientPolicyTls").add("Enforce", (Object)this.enforce()).add("Ports", this.ports()).add("Validation", (Object)this.validation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enforce": {
                return Optional.ofNullable(clazz.cast(this.enforce()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
            case "validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayClientPolicyTls, T> g) {
        return obj -> g.apply((VirtualGatewayClientPolicyTls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enforce;
        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();
        private VirtualGatewayTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayClientPolicyTls model) {
            this.enforce(model.enforce);
            this.ports(model.ports);
            this.validation(model.validation);
        }

        public final Boolean getEnforce() {
            return this.enforce;
        }

        @Override
        public final Builder enforce(Boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        public final void setEnforce(Boolean enforce) {
            this.enforce = enforce;
        }

        public final Collection<Integer> getPorts() {
            return this.ports;
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
        }

        public final VirtualGatewayTlsValidationContext.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        @Override
        public final Builder validation(VirtualGatewayTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        public final void setValidation(VirtualGatewayTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        public VirtualGatewayClientPolicyTls build() {
            return new VirtualGatewayClientPolicyTls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayClientPolicyTls> {
        public Builder enforce(Boolean var1);

        public Builder ports(Collection<Integer> var1);

        public Builder ports(Integer ... var1);

        public Builder validation(VirtualGatewayTlsValidationContext var1);

        default public Builder validation(Consumer<VirtualGatewayTlsValidationContext.Builder> validation) {
            return this.validation((VirtualGatewayTlsValidationContext)((VirtualGatewayTlsValidationContext.Builder)VirtualGatewayTlsValidationContext.builder().applyMutation(validation)).build());
        }
    }
}

