/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy;
import software.amazon.awssdk.services.appmesh.model.ListenerTimeout;
import software.amazon.awssdk.services.appmesh.model.ListenerTls;
import software.amazon.awssdk.services.appmesh.model.PortMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Listener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Listener> {
    private static final SdkField<HealthCheckPolicy> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Listener.getter(Listener::healthCheck)).setter(Listener.setter(Builder::healthCheck)).constructor(HealthCheckPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final SdkField<PortMapping> PORT_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Listener.getter(Listener::portMapping)).setter(Listener.setter(Builder::portMapping)).constructor(PortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMapping").build()}).build();
    private static final SdkField<ListenerTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Listener.getter(Listener::timeout)).setter(Listener.setter(Builder::timeout)).constructor(ListenerTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<ListenerTls> TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Listener.getter(Listener::tls)).setter(Listener.setter(Builder::tls)).constructor(ListenerTls::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD, PORT_MAPPING_FIELD, TIMEOUT_FIELD, TLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final HealthCheckPolicy healthCheck;
    private final PortMapping portMapping;
    private final ListenerTimeout timeout;
    private final ListenerTls tls;

    private Listener(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
        this.portMapping = builder.portMapping;
        this.timeout = builder.timeout;
        this.tls = builder.tls;
    }

    public HealthCheckPolicy healthCheck() {
        return this.healthCheck;
    }

    public PortMapping portMapping() {
        return this.portMapping;
    }

    public ListenerTimeout timeout() {
        return this.timeout;
    }

    public ListenerTls tls() {
        return this.tls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.portMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.tls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.portMapping(), other.portMapping()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.tls(), other.tls());
    }

    public String toString() {
        return ToString.builder((String)"Listener").add("HealthCheck", (Object)this.healthCheck()).add("PortMapping", (Object)this.portMapping()).add("Timeout", (Object)this.timeout()).add("Tls", (Object)this.tls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "portMapping": {
                return Optional.ofNullable(clazz.cast(this.portMapping()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "tls": {
                return Optional.ofNullable(clazz.cast(this.tls()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HealthCheckPolicy healthCheck;
        private PortMapping portMapping;
        private ListenerTimeout timeout;
        private ListenerTls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.healthCheck(model.healthCheck);
            this.portMapping(model.portMapping);
            this.timeout(model.timeout);
            this.tls(model.tls);
        }

        public final HealthCheckPolicy.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheckPolicy healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheckPolicy.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final PortMapping.Builder getPortMapping() {
            return this.portMapping != null ? this.portMapping.toBuilder() : null;
        }

        @Override
        public final Builder portMapping(PortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public final void setPortMapping(PortMapping.BuilderImpl portMapping) {
            this.portMapping = portMapping != null ? portMapping.build() : null;
        }

        public final ListenerTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(ListenerTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(ListenerTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        public final ListenerTls.Builder getTls() {
            return this.tls != null ? this.tls.toBuilder() : null;
        }

        @Override
        public final Builder tls(ListenerTls tls) {
            this.tls = tls;
            return this;
        }

        public final void setTls(ListenerTls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        public Listener build() {
            return new Listener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Listener> {
        public Builder healthCheck(HealthCheckPolicy var1);

        default public Builder healthCheck(Consumer<HealthCheckPolicy.Builder> healthCheck) {
            return this.healthCheck((HealthCheckPolicy)((HealthCheckPolicy.Builder)HealthCheckPolicy.builder().applyMutation(healthCheck)).build());
        }

        public Builder portMapping(PortMapping var1);

        default public Builder portMapping(Consumer<PortMapping.Builder> portMapping) {
            return this.portMapping((PortMapping)((PortMapping.Builder)PortMapping.builder().applyMutation(portMapping)).build());
        }

        public Builder timeout(ListenerTimeout var1);

        default public Builder timeout(Consumer<ListenerTimeout.Builder> timeout) {
            return this.timeout((ListenerTimeout)((ListenerTimeout.Builder)ListenerTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder tls(ListenerTls var1);

        default public Builder tls(Consumer<ListenerTls.Builder> tls) {
            return this.tls((ListenerTls)((ListenerTls.Builder)ListenerTls.builder().applyMutation(tls)).build());
        }
    }
}

