/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsValidationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<TlsValidationContext.Builder, TlsValidationContext> {
    private static final SdkField<TlsValidationContextTrust> TRUST_FIELD = SdkField
            .<TlsValidationContextTrust> builder(MarshallingType.SDK_POJO).getter(getter(TlsValidationContext::trust))
            .setter(setter(Builder::trust)).constructor(TlsValidationContextTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trust").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_FIELD));

    private static final long serialVersionUID = 1L;

    private final TlsValidationContextTrust trust;

    private TlsValidationContext(BuilderImpl builder) {
        this.trust = builder.trust;
    }

    /**
     * <p>
     * A reference to an object that represents a TLS validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents a TLS validation context trust.
     */
    public TlsValidationContextTrust trust() {
        return trust;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trust());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsValidationContext)) {
            return false;
        }
        TlsValidationContext other = (TlsValidationContext) obj;
        return Objects.equals(trust(), other.trust());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TlsValidationContext").add("Trust", trust()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trust":
            return Optional.ofNullable(clazz.cast(trust()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsValidationContext, T> g) {
        return obj -> g.apply((TlsValidationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsValidationContext> {
        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust.
         * </p>
         * 
         * @param trust
         *        A reference to an object that represents a TLS validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trust(TlsValidationContextTrust trust);

        /**
         * <p>
         * A reference to an object that represents a TLS validation context trust.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsValidationContextTrust.Builder} avoiding the
         * need to create one manually via {@link TlsValidationContextTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsValidationContextTrust.Builder#build()} is called immediately
         * and its result is passed to {@link #trust(TlsValidationContextTrust)}.
         * 
         * @param trust
         *        a consumer that will call methods on {@link TlsValidationContextTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trust(TlsValidationContextTrust)
         */
        default Builder trust(Consumer<TlsValidationContextTrust.Builder> trust) {
            return trust(TlsValidationContextTrust.builder().applyMutation(trust).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TlsValidationContextTrust trust;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsValidationContext model) {
            trust(model.trust);
        }

        public final TlsValidationContextTrust.Builder getTrust() {
            return trust != null ? trust.toBuilder() : null;
        }

        @Override
        public final Builder trust(TlsValidationContextTrust trust) {
            this.trust = trust;
            return this;
        }

        public final void setTrust(TlsValidationContextTrust.BuilderImpl trust) {
            this.trust = trust != null ? trust.build() : null;
        }

        @Override
        public TlsValidationContext build() {
            return new TlsValidationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
