/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.PortProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheckPolicy> {
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HealthCheckPolicy.getter(HealthCheckPolicy::healthyThreshold)).setter(HealthCheckPolicy.setter(Builder::healthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThreshold").build()}).build();
    private static final SdkField<Long> INTERVAL_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(HealthCheckPolicy.getter(HealthCheckPolicy::intervalMillis)).setter(HealthCheckPolicy.setter(Builder::intervalMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalMillis").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HealthCheckPolicy.getter(HealthCheckPolicy::path)).setter(HealthCheckPolicy.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HealthCheckPolicy.getter(HealthCheckPolicy::port)).setter(HealthCheckPolicy.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HealthCheckPolicy.getter(HealthCheckPolicy::protocolAsString)).setter(HealthCheckPolicy.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Long> TIMEOUT_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(HealthCheckPolicy.getter(HealthCheckPolicy::timeoutMillis)).setter(HealthCheckPolicy.setter(Builder::timeoutMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMillis").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HealthCheckPolicy.getter(HealthCheckPolicy::unhealthyThreshold)).setter(HealthCheckPolicy.setter(Builder::unhealthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTHY_THRESHOLD_FIELD, INTERVAL_MILLIS_FIELD, PATH_FIELD, PORT_FIELD, PROTOCOL_FIELD, TIMEOUT_MILLIS_FIELD, UNHEALTHY_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer healthyThreshold;
    private final Long intervalMillis;
    private final String path;
    private final Integer port;
    private final String protocol;
    private final Long timeoutMillis;
    private final Integer unhealthyThreshold;

    private HealthCheckPolicy(BuilderImpl builder) {
        this.healthyThreshold = builder.healthyThreshold;
        this.intervalMillis = builder.intervalMillis;
        this.path = builder.path;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.timeoutMillis = builder.timeoutMillis;
        this.unhealthyThreshold = builder.unhealthyThreshold;
    }

    public Integer healthyThreshold() {
        return this.healthyThreshold;
    }

    public Long intervalMillis() {
        return this.intervalMillis;
    }

    public String path() {
        return this.path;
    }

    public Integer port() {
        return this.port;
    }

    public PortProtocol protocol() {
        return PortProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Long timeoutMillis() {
        return this.timeoutMillis;
    }

    public Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckPolicy)) {
            return false;
        }
        HealthCheckPolicy other = (HealthCheckPolicy)obj;
        return Objects.equals(this.healthyThreshold(), other.healthyThreshold()) && Objects.equals(this.intervalMillis(), other.intervalMillis()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.timeoutMillis(), other.timeoutMillis()) && Objects.equals(this.unhealthyThreshold(), other.unhealthyThreshold());
    }

    public String toString() {
        return ToString.builder((String)"HealthCheckPolicy").add("HealthyThreshold", (Object)this.healthyThreshold()).add("IntervalMillis", (Object)this.intervalMillis()).add("Path", (Object)this.path()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("TimeoutMillis", (Object)this.timeoutMillis()).add("UnhealthyThreshold", (Object)this.unhealthyThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthyThreshold()));
            }
            case "intervalMillis": {
                return Optional.ofNullable(clazz.cast(this.intervalMillis()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "timeoutMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutMillis()));
            }
            case "unhealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThreshold()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckPolicy, T> g) {
        return obj -> g.apply((HealthCheckPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer healthyThreshold;
        private Long intervalMillis;
        private String path;
        private Integer port;
        private String protocol;
        private Long timeoutMillis;
        private Integer unhealthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckPolicy model) {
            this.healthyThreshold(model.healthyThreshold);
            this.intervalMillis(model.intervalMillis);
            this.path(model.path);
            this.port(model.port);
            this.protocol(model.protocol);
            this.timeoutMillis(model.timeoutMillis);
            this.unhealthyThreshold(model.unhealthyThreshold);
        }

        public final Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public final Long getIntervalMillis() {
            return this.intervalMillis;
        }

        @Override
        public final Builder intervalMillis(Long intervalMillis) {
            this.intervalMillis = intervalMillis;
            return this;
        }

        public final void setIntervalMillis(Long intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(PortProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public final Builder timeoutMillis(Long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public final void setTimeoutMillis(Long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public final Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public HealthCheckPolicy build() {
            return new HealthCheckPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheckPolicy> {
        public Builder healthyThreshold(Integer var1);

        public Builder intervalMillis(Long var1);

        public Builder path(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(PortProtocol var1);

        public Builder timeoutMillis(Long var1);

        public Builder unhealthyThreshold(Integer var1);
    }
}

