/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy;
import software.amazon.awssdk.services.appmesh.model.GrpcRouteAction;
import software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrpcRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrpcRoute> {
    private static final SdkField<GrpcRouteAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GrpcRoute.getter(GrpcRoute::action)).setter(GrpcRoute.setter(Builder::action)).constructor(GrpcRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<GrpcRouteMatch> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GrpcRoute.getter(GrpcRoute::match)).setter(GrpcRoute.setter(Builder::match)).constructor(GrpcRouteMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final SdkField<GrpcRetryPolicy> RETRY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GrpcRoute.getter(GrpcRoute::retryPolicy)).setter(GrpcRoute.setter(Builder::retryPolicy)).constructor(GrpcRetryPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD, RETRY_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final GrpcRouteAction action;
    private final GrpcRouteMatch match;
    private final GrpcRetryPolicy retryPolicy;

    private GrpcRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.retryPolicy = builder.retryPolicy;
    }

    public GrpcRouteAction action() {
        return this.action;
    }

    public GrpcRouteMatch match() {
        return this.match;
    }

    public GrpcRetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRoute)) {
            return false;
        }
        GrpcRoute other = (GrpcRoute)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.match(), other.match()) && Objects.equals(this.retryPolicy(), other.retryPolicy());
    }

    public String toString() {
        return ToString.builder((String)"GrpcRoute").add("Action", (Object)this.action()).add("Match", (Object)this.match()).add("RetryPolicy", (Object)this.retryPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
            case "retryPolicy": {
                return Optional.ofNullable(clazz.cast(this.retryPolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRoute, T> g) {
        return obj -> g.apply((GrpcRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GrpcRouteAction action;
        private GrpcRouteMatch match;
        private GrpcRetryPolicy retryPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRoute model) {
            this.action(model.action);
            this.match(model.match);
            this.retryPolicy(model.retryPolicy);
        }

        public final GrpcRouteAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(GrpcRouteAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(GrpcRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final GrpcRouteMatch.Builder getMatch() {
            return this.match != null ? this.match.toBuilder() : null;
        }

        @Override
        public final Builder match(GrpcRouteMatch match) {
            this.match = match;
            return this;
        }

        public final void setMatch(GrpcRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        public final GrpcRetryPolicy.Builder getRetryPolicy() {
            return this.retryPolicy != null ? this.retryPolicy.toBuilder() : null;
        }

        @Override
        public final Builder retryPolicy(GrpcRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final void setRetryPolicy(GrpcRetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        public GrpcRoute build() {
            return new GrpcRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrpcRoute> {
        public Builder action(GrpcRouteAction var1);

        default public Builder action(Consumer<GrpcRouteAction.Builder> action) {
            return this.action((GrpcRouteAction)((GrpcRouteAction.Builder)GrpcRouteAction.builder().applyMutation(action)).build());
        }

        public Builder match(GrpcRouteMatch var1);

        default public Builder match(Consumer<GrpcRouteMatch.Builder> match) {
            return this.match((GrpcRouteMatch)((GrpcRouteMatch.Builder)GrpcRouteMatch.builder().applyMutation(match)).build());
        }

        public Builder retryPolicy(GrpcRetryPolicy var1);

        default public Builder retryPolicy(Consumer<GrpcRetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy((GrpcRetryPolicy)((GrpcRetryPolicy.Builder)GrpcRetryPolicy.builder().applyMutation(retryPolicy)).build());
        }
    }
}

