/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.MeshSpec;
import software.amazon.awssdk.services.appmesh.model.MeshStatus;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeshData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeshData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MeshData.getter(MeshData::meshName)).setter(MeshData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeshData.getter(MeshData::metadata)).setter(MeshData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<MeshSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeshData.getter(MeshData::spec)).setter(MeshData.setter(Builder::spec)).constructor(MeshSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<MeshStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeshData.getter(MeshData::status)).setter(MeshData.setter(Builder::status)).constructor(MeshStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final MeshSpec spec;
    private final MeshStatus status;

    private MeshData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
    }

    public String meshName() {
        return this.meshName;
    }

    public ResourceMetadata metadata() {
        return this.metadata;
    }

    public MeshSpec spec() {
        return this.spec;
    }

    public MeshStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeshData)) {
            return false;
        }
        MeshData other = (MeshData)obj;
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"MeshData").add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeshData, T> g) {
        return obj -> g.apply((MeshData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meshName;
        private ResourceMetadata metadata;
        private MeshSpec spec;
        private MeshStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(MeshData model) {
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.spec(model.spec);
            this.status(model.status);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final MeshSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(MeshSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(MeshSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final MeshStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(MeshStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(MeshStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public MeshData build() {
            return new MeshData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeshData> {
        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder spec(MeshSpec var1);

        default public Builder spec(Consumer<MeshSpec.Builder> spec) {
            return this.spec((MeshSpec)((MeshSpec.Builder)MeshSpec.builder().applyMutation(spec)).build());
        }

        public Builder status(MeshStatus var1);

        default public Builder status(Consumer<MeshStatus.Builder> status) {
            return this.status((MeshStatus)((MeshStatus.Builder)MeshStatus.builder().applyMutation(status)).build());
        }
    }
}

