/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.HttpMethod;
import software.amazon.awssdk.services.appmesh.model.HttpRouteHeader;
import software.amazon.awssdk.services.appmesh.model.HttpRouteHeadersCopier;
import software.amazon.awssdk.services.appmesh.model.HttpScheme;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRouteMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRouteMatch> {
    private static final SdkField<List<HttpRouteHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HttpRouteMatch.getter(HttpRouteMatch::headers)).setter(HttpRouteMatch.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpRouteHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpRouteMatch.getter(HttpRouteMatch::methodAsString)).setter(HttpRouteMatch.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpRouteMatch.getter(HttpRouteMatch::prefix)).setter(HttpRouteMatch.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpRouteMatch.getter(HttpRouteMatch::schemeAsString)).setter(HttpRouteMatch.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, METHOD_FIELD, PREFIX_FIELD, SCHEME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<HttpRouteHeader> headers;
    private final String method;
    private final String prefix;
    private final String scheme;

    private HttpRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.method = builder.method;
        this.prefix = builder.prefix;
        this.scheme = builder.scheme;
    }

    public boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public List<HttpRouteHeader> headers() {
        return this.headers;
    }

    public HttpMethod method() {
        return HttpMethod.fromValue(this.method);
    }

    public String methodAsString() {
        return this.method;
    }

    public String prefix() {
        return this.prefix;
    }

    public HttpScheme scheme() {
        return HttpScheme.fromValue(this.scheme);
    }

    public String schemeAsString() {
        return this.scheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteMatch)) {
            return false;
        }
        HttpRouteMatch other = (HttpRouteMatch)obj;
        return Objects.equals(this.headers(), other.headers()) && Objects.equals(this.methodAsString(), other.methodAsString()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.schemeAsString(), other.schemeAsString());
    }

    public String toString() {
        return ToString.builder((String)"HttpRouteMatch").add("Headers", this.headers()).add("Method", (Object)this.methodAsString()).add("Prefix", (Object)this.prefix()).add("Scheme", (Object)this.schemeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "scheme": {
                return Optional.ofNullable(clazz.cast(this.schemeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRouteMatch, T> g) {
        return obj -> g.apply((HttpRouteMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HttpRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private String method;
        private String prefix;
        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRouteMatch model) {
            this.headers(model.headers);
            this.method(model.method);
            this.prefix(model.prefix);
            this.scheme(model.scheme);
        }

        public final Collection<HttpRouteHeader.Builder> getHeaders() {
            return this.headers != null ? (Collection)this.headers.stream().map(HttpRouteHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder headers(Collection<HttpRouteHeader> headers) {
            this.headers = HttpRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HttpRouteHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HttpRouteHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (HttpRouteHeader)((HttpRouteHeader.Builder)HttpRouteHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHeaders(Collection<HttpRouteHeader.BuilderImpl> headers) {
            this.headers = HttpRouteHeadersCopier.copyFromBuilder(headers);
        }

        public final String getMethodAsString() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getSchemeAsString() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(HttpScheme scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public HttpRouteMatch build() {
            return new HttpRouteMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRouteMatch> {
        public Builder headers(Collection<HttpRouteHeader> var1);

        public Builder headers(HttpRouteHeader ... var1);

        public Builder headers(Consumer<HttpRouteHeader.Builder> ... var1);

        public Builder method(String var1);

        public Builder method(HttpMethod var1);

        public Builder prefix(String var1);

        public Builder scheme(String var1);

        public Builder scheme(HttpScheme var1);
    }
}

