/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.model.ListMeshesRequest;
import software.amazon.awssdk.services.appmesh.model.ListMeshesResponse;
import software.amazon.awssdk.services.appmesh.model.MeshRef;

public class ListMeshesIterable
implements SdkIterable<ListMeshesResponse> {
    private final AppMeshClient client;
    private final ListMeshesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMeshesIterable(AppMeshClient client, ListMeshesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMeshesResponseFetcher();
    }

    public Iterator<ListMeshesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MeshRef> meshes() {
        Function<ListMeshesResponse, Iterator> getIterator = response -> {
            if (response != null && response.meshes() != null) {
                return response.meshes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListMeshesIterable resume(ListMeshesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMeshesIterable(this.client, (ListMeshesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListMeshesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMeshesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMeshesResponseFetcher
    implements SyncPageFetcher<ListMeshesResponse> {
        private ListMeshesResponseFetcher() {
        }

        public boolean hasNextPage(ListMeshesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMeshesResponse nextPage(ListMeshesResponse previousPage) {
            if (previousPage == null) {
                return ListMeshesIterable.this.client.listMeshes(ListMeshesIterable.this.firstRequest);
            }
            return ListMeshesIterable.this.client.listMeshes((ListMeshesRequest)((Object)ListMeshesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

