/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricReference;
import software.amazon.awssdk.services.applicationsignals.model.MetricReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDependency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDependency> {
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(ServiceDependency.getter(ServiceDependency::operationName)).setter(ServiceDependency.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<Map<String, String>> DEPENDENCY_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DependencyKeyAttributes").getter(ServiceDependency.getter(ServiceDependency::dependencyKeyAttributes)).setter(ServiceDependency.setter(Builder::dependencyKeyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyKeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEPENDENCY_OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DependencyOperationName").getter(ServiceDependency.getter(ServiceDependency::dependencyOperationName)).setter(ServiceDependency.setter(Builder::dependencyOperationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyOperationName").build()}).build();
    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricReferences").getter(ServiceDependency.getter(ServiceDependency::metricReferences)).setter(ServiceDependency.setter(Builder::metricReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_NAME_FIELD, DEPENDENCY_KEY_ATTRIBUTES_FIELD, DEPENDENCY_OPERATION_NAME_FIELD, METRIC_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceDependency.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operationName;
    private final Map<String, String> dependencyKeyAttributes;
    private final String dependencyOperationName;
    private final List<MetricReference> metricReferences;

    private ServiceDependency(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.dependencyKeyAttributes = builder.dependencyKeyAttributes;
        this.dependencyOperationName = builder.dependencyOperationName;
        this.metricReferences = builder.metricReferences;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final boolean hasDependencyKeyAttributes() {
        return this.dependencyKeyAttributes != null && !(this.dependencyKeyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dependencyKeyAttributes() {
        return this.dependencyKeyAttributes;
    }

    public final String dependencyOperationName() {
        return this.dependencyOperationName;
    }

    public final boolean hasMetricReferences() {
        return this.metricReferences != null && !(this.metricReferences instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> metricReferences() {
        return this.metricReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencyKeyAttributes() ? this.dependencyKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyOperationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricReferences() ? this.metricReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDependency)) {
            return false;
        }
        ServiceDependency other = (ServiceDependency)obj;
        return Objects.equals(this.operationName(), other.operationName()) && this.hasDependencyKeyAttributes() == other.hasDependencyKeyAttributes() && Objects.equals(this.dependencyKeyAttributes(), other.dependencyKeyAttributes()) && Objects.equals(this.dependencyOperationName(), other.dependencyOperationName()) && this.hasMetricReferences() == other.hasMetricReferences() && Objects.equals(this.metricReferences(), other.metricReferences());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDependency").add("OperationName", (Object)this.operationName()).add("DependencyKeyAttributes", this.hasDependencyKeyAttributes() ? this.dependencyKeyAttributes() : null).add("DependencyOperationName", (Object)this.dependencyOperationName()).add("MetricReferences", this.hasMetricReferences() ? this.metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "DependencyKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.dependencyKeyAttributes()));
            }
            case "DependencyOperationName": {
                return Optional.ofNullable(clazz.cast(this.dependencyOperationName()));
            }
            case "MetricReferences": {
                return Optional.ofNullable(clazz.cast(this.metricReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("DependencyKeyAttributes", DEPENDENCY_KEY_ATTRIBUTES_FIELD);
        map.put("DependencyOperationName", DEPENDENCY_OPERATION_NAME_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDependency, T> g) {
        return obj -> g.apply((ServiceDependency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationName;
        private Map<String, String> dependencyKeyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String dependencyOperationName;
        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDependency model) {
            this.operationName(model.operationName);
            this.dependencyKeyAttributes(model.dependencyKeyAttributes);
            this.dependencyOperationName(model.dependencyOperationName);
            this.metricReferences(model.metricReferences);
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Map<String, String> getDependencyKeyAttributes() {
            if (this.dependencyKeyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dependencyKeyAttributes;
        }

        public final void setDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
        }

        @Override
        public final Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
            return this;
        }

        public final String getDependencyOperationName() {
            return this.dependencyOperationName;
        }

        public final void setDependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
        }

        @Override
        public final Builder dependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference ... metricReferences) {
            this.metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder> ... metricReferences) {
            this.metricReferences(Stream.of(metricReferences).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceDependency build() {
            return new ServiceDependency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDependency> {
        public Builder operationName(String var1);

        public Builder dependencyKeyAttributes(Map<String, String> var1);

        public Builder dependencyOperationName(String var1);

        public Builder metricReferences(Collection<MetricReference> var1);

        public Builder metricReferences(MetricReference ... var1);

        public Builder metricReferences(Consumer<MetricReference.Builder> ... var1);
    }
}

