/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceOperation;

public class ListServiceOperationsPublisher
implements SdkPublisher<ListServiceOperationsResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceOperationsPublisher(ApplicationSignalsAsyncClient client, ListServiceOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceOperationsPublisher(ApplicationSignalsAsyncClient client, ListServiceOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceOperation> serviceOperations() {
        Function<ListServiceOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceOperations() != null) {
                return response.serviceOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceOperationsResponseFetcher
    implements AsyncPageFetcher<ListServiceOperationsResponse> {
        private ListServiceOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceOperationsResponse> nextPage(ListServiceOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceOperationsPublisher.this.client.listServiceOperations(ListServiceOperationsPublisher.this.firstRequest);
            }
            return ListServiceOperationsPublisher.this.client.listServiceOperations((ListServiceOperationsRequest)((Object)ListServiceOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

