/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicatorMetricConfig;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorComparisonOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestBasedServiceLevelIndicatorConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestBasedServiceLevelIndicatorConfig> {
    private static final SdkField<RequestBasedServiceLevelIndicatorMetricConfig> REQUEST_BASED_SLI_METRIC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSliMetricConfig").getter(RequestBasedServiceLevelIndicatorConfig.getter(RequestBasedServiceLevelIndicatorConfig::requestBasedSliMetricConfig)).setter(RequestBasedServiceLevelIndicatorConfig.setter(Builder::requestBasedSliMetricConfig)).constructor(RequestBasedServiceLevelIndicatorMetricConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliMetricConfig").build()}).build();
    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricThreshold").getter(RequestBasedServiceLevelIndicatorConfig.getter(RequestBasedServiceLevelIndicatorConfig::metricThreshold)).setter(RequestBasedServiceLevelIndicatorConfig.setter(Builder::metricThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(RequestBasedServiceLevelIndicatorConfig.getter(RequestBasedServiceLevelIndicatorConfig::comparisonOperatorAsString)).setter(RequestBasedServiceLevelIndicatorConfig.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_BASED_SLI_METRIC_CONFIG_FIELD, METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final RequestBasedServiceLevelIndicatorMetricConfig requestBasedSliMetricConfig;
    private final Double metricThreshold;
    private final String comparisonOperator;

    private RequestBasedServiceLevelIndicatorConfig(BuilderImpl builder) {
        this.requestBasedSliMetricConfig = builder.requestBasedSliMetricConfig;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public final RequestBasedServiceLevelIndicatorMetricConfig requestBasedSliMetricConfig() {
        return this.requestBasedSliMetricConfig;
    }

    public final Double metricThreshold() {
        return this.metricThreshold;
    }

    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSliMetricConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestBasedServiceLevelIndicatorConfig)) {
            return false;
        }
        RequestBasedServiceLevelIndicatorConfig other = (RequestBasedServiceLevelIndicatorConfig)obj;
        return Objects.equals(this.requestBasedSliMetricConfig(), other.requestBasedSliMetricConfig()) && Objects.equals(this.metricThreshold(), other.metricThreshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RequestBasedServiceLevelIndicatorConfig").add("RequestBasedSliMetricConfig", (Object)this.requestBasedSliMetricConfig()).add("MetricThreshold", (Object)this.metricThreshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestBasedSliMetricConfig": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSliMetricConfig()));
            }
            case "MetricThreshold": {
                return Optional.ofNullable(clazz.cast(this.metricThreshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestBasedServiceLevelIndicatorConfig, T> g) {
        return obj -> g.apply((RequestBasedServiceLevelIndicatorConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RequestBasedServiceLevelIndicatorMetricConfig requestBasedSliMetricConfig;
        private Double metricThreshold;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestBasedServiceLevelIndicatorConfig model) {
            this.requestBasedSliMetricConfig(model.requestBasedSliMetricConfig);
            this.metricThreshold(model.metricThreshold);
            this.comparisonOperator(model.comparisonOperator);
        }

        public final RequestBasedServiceLevelIndicatorMetricConfig.Builder getRequestBasedSliMetricConfig() {
            return this.requestBasedSliMetricConfig != null ? this.requestBasedSliMetricConfig.toBuilder() : null;
        }

        public final void setRequestBasedSliMetricConfig(RequestBasedServiceLevelIndicatorMetricConfig.BuilderImpl requestBasedSliMetricConfig) {
            this.requestBasedSliMetricConfig = requestBasedSliMetricConfig != null ? requestBasedSliMetricConfig.build() : null;
        }

        @Override
        public final Builder requestBasedSliMetricConfig(RequestBasedServiceLevelIndicatorMetricConfig requestBasedSliMetricConfig) {
            this.requestBasedSliMetricConfig = requestBasedSliMetricConfig;
            return this;
        }

        public final Double getMetricThreshold() {
            return this.metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public RequestBasedServiceLevelIndicatorConfig build() {
            return new RequestBasedServiceLevelIndicatorConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestBasedServiceLevelIndicatorConfig> {
        public Builder requestBasedSliMetricConfig(RequestBasedServiceLevelIndicatorMetricConfig var1);

        default public Builder requestBasedSliMetricConfig(Consumer<RequestBasedServiceLevelIndicatorMetricConfig.Builder> requestBasedSliMetricConfig) {
            return this.requestBasedSliMetricConfig((RequestBasedServiceLevelIndicatorMetricConfig)((RequestBasedServiceLevelIndicatorMetricConfig.Builder)RequestBasedServiceLevelIndicatorMetricConfig.builder().applyMutation(requestBasedSliMetricConfig)).build());
        }

        public Builder metricThreshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator var1);
    }
}

