/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.Dimension;
import software.amazon.awssdk.services.applicationsignals.model.DimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricReference> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(MetricReference.getter(MetricReference::namespace)).setter(MetricReference.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(MetricReference.getter(MetricReference::metricType)).setter(MetricReference.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(MetricReference.getter(MetricReference::dimensions)).setter(MetricReference.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricReference.getter(MetricReference::metricName)).setter(MetricReference.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_TYPE_FIELD, DIMENSIONS_FIELD, METRIC_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String metricType;
    private final List<Dimension> dimensions;
    private final String metricName;

    private MetricReference(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricType = builder.metricType;
        this.dimensions = builder.dimensions;
        this.metricName = builder.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String metricType() {
        return this.metricType;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public final String metricName() {
        return this.metricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricReference)) {
            return false;
        }
        MetricReference other = (MetricReference)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricType(), other.metricType()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.metricName(), other.metricName());
    }

    public final String toString() {
        return ToString.builder((String)"MetricReference").add("Namespace", (Object)this.namespace()).add("MetricType", (Object)this.metricType()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("MetricName", (Object)this.metricName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricType()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricReference, T> g) {
        return obj -> g.apply((MetricReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricType;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricReference model) {
            this.namespace(model.namespace);
            this.metricType(model.metricType);
            this.dimensions(model.dimensions);
            this.metricName(model.metricName);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public MetricReference build() {
            return new MetricReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricReference> {
        public Builder namespace(String var1);

        public Builder metricType(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder metricName(String var1);
    }
}

