/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an anomaly or error with the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Observation implements SdkPojo, Serializable, ToCopyableBuilder<Observation.Builder, Observation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Observation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(Observation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(Observation::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(Observation::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceARN").getter(getter(Observation::sourceARN)).setter(setter(Builder::sourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceARN").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroup").getter(getter(Observation::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<Instant> LINE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LineTime").getter(getter(Observation::lineTime)).setter(setter(Builder::lineTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineTime").build()).build();

    private static final SdkField<String> LOG_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogText").getter(getter(Observation::logText)).setter(setter(Builder::logText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogText").build()).build();

    private static final SdkField<String> LOG_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFilter").getter(getter(Observation::logFilterAsString)).setter(setter(Builder::logFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilter").build()).build();

    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricNamespace").getter(getter(Observation::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(Observation::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Observation::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(Observation::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> CLOUD_WATCH_EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchEventId").getter(getter(Observation::cloudWatchEventId))
            .setter(setter(Builder::cloudWatchEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventId").build()).build();

    private static final SdkField<String> CLOUD_WATCH_EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchEventSource").getter(getter(Observation::cloudWatchEventSourceAsString))
            .setter(setter(Builder::cloudWatchEventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventSource").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_EVENT_DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchEventDetailType").getter(getter(Observation::cloudWatchEventDetailType))
            .setter(setter(Builder::cloudWatchEventDetailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventDetailType").build())
            .build();

    private static final SdkField<String> HEALTH_EVENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthEventArn").getter(getter(Observation::healthEventArn)).setter(setter(Builder::healthEventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventArn").build()).build();

    private static final SdkField<String> HEALTH_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthService").getter(getter(Observation::healthService)).setter(setter(Builder::healthService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthService").build()).build();

    private static final SdkField<String> HEALTH_EVENT_TYPE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthEventTypeCode").getter(getter(Observation::healthEventTypeCode))
            .setter(setter(Builder::healthEventTypeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventTypeCode").build())
            .build();

    private static final SdkField<String> HEALTH_EVENT_TYPE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthEventTypeCategory").getter(getter(Observation::healthEventTypeCategory))
            .setter(setter(Builder::healthEventTypeCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventTypeCategory").build())
            .build();

    private static final SdkField<String> HEALTH_EVENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthEventDescription").getter(getter(Observation::healthEventDescription))
            .setter(setter(Builder::healthEventDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventDescription").build())
            .build();

    private static final SdkField<String> CODE_DEPLOY_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeDeployDeploymentId").getter(getter(Observation::codeDeployDeploymentId))
            .setter(setter(Builder::codeDeployDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployDeploymentId").build())
            .build();

    private static final SdkField<String> CODE_DEPLOY_DEPLOYMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeDeployDeploymentGroup").getter(getter(Observation::codeDeployDeploymentGroup))
            .setter(setter(Builder::codeDeployDeploymentGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployDeploymentGroup").build())
            .build();

    private static final SdkField<String> CODE_DEPLOY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeDeployState").getter(getter(Observation::codeDeployState)).setter(setter(Builder::codeDeployState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployState").build()).build();

    private static final SdkField<String> CODE_DEPLOY_APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeDeployApplication").getter(getter(Observation::codeDeployApplication))
            .setter(setter(Builder::codeDeployApplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployApplication").build())
            .build();

    private static final SdkField<String> CODE_DEPLOY_INSTANCE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeDeployInstanceGroupId").getter(getter(Observation::codeDeployInstanceGroupId))
            .setter(setter(Builder::codeDeployInstanceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployInstanceGroupId").build())
            .build();

    private static final SdkField<String> EC2_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2State").getter(getter(Observation::ec2State)).setter(setter(Builder::ec2State))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2State").build()).build();

    private static final SdkField<String> RDS_EVENT_CATEGORIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RdsEventCategories").getter(getter(Observation::rdsEventCategories))
            .setter(setter(Builder::rdsEventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEventCategories").build())
            .build();

    private static final SdkField<String> RDS_EVENT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RdsEventMessage").getter(getter(Observation::rdsEventMessage)).setter(setter(Builder::rdsEventMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEventMessage").build()).build();

    private static final SdkField<String> S3_EVENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3EventName").getter(getter(Observation::s3EventName)).setter(setter(Builder::s3EventName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3EventName").build()).build();

    private static final SdkField<String> STATES_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatesExecutionArn").getter(getter(Observation::statesExecutionArn))
            .setter(setter(Builder::statesExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatesExecutionArn").build())
            .build();

    private static final SdkField<String> STATES_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatesArn").getter(getter(Observation::statesArn)).setter(setter(Builder::statesArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatesArn").build()).build();

    private static final SdkField<String> STATES_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatesStatus").getter(getter(Observation::statesStatus)).setter(setter(Builder::statesStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatesStatus").build()).build();

    private static final SdkField<String> STATES_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatesInput").getter(getter(Observation::statesInput)).setter(setter(Builder::statesInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatesInput").build()).build();

    private static final SdkField<String> EBS_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsEvent").getter(getter(Observation::ebsEvent)).setter(setter(Builder::ebsEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsEvent").build()).build();

    private static final SdkField<String> EBS_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsResult").getter(getter(Observation::ebsResult)).setter(setter(Builder::ebsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsResult").build()).build();

    private static final SdkField<String> EBS_CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsCause").getter(getter(Observation::ebsCause)).setter(setter(Builder::ebsCause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsCause").build()).build();

    private static final SdkField<String> EBS_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsRequestId").getter(getter(Observation::ebsRequestId)).setter(setter(Builder::ebsRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsRequestId").build()).build();

    private static final SdkField<Integer> X_RAY_FAULT_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XRayFaultPercent").getter(getter(Observation::xRayFaultPercent))
            .setter(setter(Builder::xRayFaultPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayFaultPercent").build()).build();

    private static final SdkField<Integer> X_RAY_THROTTLE_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XRayThrottlePercent").getter(getter(Observation::xRayThrottlePercent))
            .setter(setter(Builder::xRayThrottlePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayThrottlePercent").build())
            .build();

    private static final SdkField<Integer> X_RAY_ERROR_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XRayErrorPercent").getter(getter(Observation::xRayErrorPercent))
            .setter(setter(Builder::xRayErrorPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayErrorPercent").build()).build();

    private static final SdkField<Integer> X_RAY_REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XRayRequestCount").getter(getter(Observation::xRayRequestCount))
            .setter(setter(Builder::xRayRequestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayRequestCount").build()).build();

    private static final SdkField<Long> X_RAY_REQUEST_AVERAGE_LATENCY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("XRayRequestAverageLatency").getter(getter(Observation::xRayRequestAverageLatency))
            .setter(setter(Builder::xRayRequestAverageLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayRequestAverageLatency").build())
            .build();

    private static final SdkField<String> X_RAY_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XRayNodeName").getter(getter(Observation::xRayNodeName)).setter(setter(Builder::xRayNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayNodeName").build()).build();

    private static final SdkField<String> X_RAY_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XRayNodeType").getter(getter(Observation::xRayNodeType)).setter(setter(Builder::xRayNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayNodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, LOG_GROUP_FIELD, LINE_TIME_FIELD, LOG_TEXT_FIELD,
            LOG_FILTER_FIELD, METRIC_NAMESPACE_FIELD, METRIC_NAME_FIELD, UNIT_FIELD, VALUE_FIELD, CLOUD_WATCH_EVENT_ID_FIELD,
            CLOUD_WATCH_EVENT_SOURCE_FIELD, CLOUD_WATCH_EVENT_DETAIL_TYPE_FIELD, HEALTH_EVENT_ARN_FIELD, HEALTH_SERVICE_FIELD,
            HEALTH_EVENT_TYPE_CODE_FIELD, HEALTH_EVENT_TYPE_CATEGORY_FIELD, HEALTH_EVENT_DESCRIPTION_FIELD,
            CODE_DEPLOY_DEPLOYMENT_ID_FIELD, CODE_DEPLOY_DEPLOYMENT_GROUP_FIELD, CODE_DEPLOY_STATE_FIELD,
            CODE_DEPLOY_APPLICATION_FIELD, CODE_DEPLOY_INSTANCE_GROUP_ID_FIELD, EC2_STATE_FIELD, RDS_EVENT_CATEGORIES_FIELD,
            RDS_EVENT_MESSAGE_FIELD, S3_EVENT_NAME_FIELD, STATES_EXECUTION_ARN_FIELD, STATES_ARN_FIELD, STATES_STATUS_FIELD,
            STATES_INPUT_FIELD, EBS_EVENT_FIELD, EBS_RESULT_FIELD, EBS_CAUSE_FIELD, EBS_REQUEST_ID_FIELD,
            X_RAY_FAULT_PERCENT_FIELD, X_RAY_THROTTLE_PERCENT_FIELD, X_RAY_ERROR_PERCENT_FIELD, X_RAY_REQUEST_COUNT_FIELD,
            X_RAY_REQUEST_AVERAGE_LATENCY_FIELD, X_RAY_NODE_NAME_FIELD, X_RAY_NODE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant startTime;

    private final Instant endTime;

    private final String sourceType;

    private final String sourceARN;

    private final String logGroup;

    private final Instant lineTime;

    private final String logText;

    private final String logFilter;

    private final String metricNamespace;

    private final String metricName;

    private final String unit;

    private final Double value;

    private final String cloudWatchEventId;

    private final String cloudWatchEventSource;

    private final String cloudWatchEventDetailType;

    private final String healthEventArn;

    private final String healthService;

    private final String healthEventTypeCode;

    private final String healthEventTypeCategory;

    private final String healthEventDescription;

    private final String codeDeployDeploymentId;

    private final String codeDeployDeploymentGroup;

    private final String codeDeployState;

    private final String codeDeployApplication;

    private final String codeDeployInstanceGroupId;

    private final String ec2State;

    private final String rdsEventCategories;

    private final String rdsEventMessage;

    private final String s3EventName;

    private final String statesExecutionArn;

    private final String statesArn;

    private final String statesStatus;

    private final String statesInput;

    private final String ebsEvent;

    private final String ebsResult;

    private final String ebsCause;

    private final String ebsRequestId;

    private final Integer xRayFaultPercent;

    private final Integer xRayThrottlePercent;

    private final Integer xRayErrorPercent;

    private final Integer xRayRequestCount;

    private final Long xRayRequestAverageLatency;

    private final String xRayNodeName;

    private final String xRayNodeType;

    private Observation(BuilderImpl builder) {
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.sourceType = builder.sourceType;
        this.sourceARN = builder.sourceARN;
        this.logGroup = builder.logGroup;
        this.lineTime = builder.lineTime;
        this.logText = builder.logText;
        this.logFilter = builder.logFilter;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.unit = builder.unit;
        this.value = builder.value;
        this.cloudWatchEventId = builder.cloudWatchEventId;
        this.cloudWatchEventSource = builder.cloudWatchEventSource;
        this.cloudWatchEventDetailType = builder.cloudWatchEventDetailType;
        this.healthEventArn = builder.healthEventArn;
        this.healthService = builder.healthService;
        this.healthEventTypeCode = builder.healthEventTypeCode;
        this.healthEventTypeCategory = builder.healthEventTypeCategory;
        this.healthEventDescription = builder.healthEventDescription;
        this.codeDeployDeploymentId = builder.codeDeployDeploymentId;
        this.codeDeployDeploymentGroup = builder.codeDeployDeploymentGroup;
        this.codeDeployState = builder.codeDeployState;
        this.codeDeployApplication = builder.codeDeployApplication;
        this.codeDeployInstanceGroupId = builder.codeDeployInstanceGroupId;
        this.ec2State = builder.ec2State;
        this.rdsEventCategories = builder.rdsEventCategories;
        this.rdsEventMessage = builder.rdsEventMessage;
        this.s3EventName = builder.s3EventName;
        this.statesExecutionArn = builder.statesExecutionArn;
        this.statesArn = builder.statesArn;
        this.statesStatus = builder.statesStatus;
        this.statesInput = builder.statesInput;
        this.ebsEvent = builder.ebsEvent;
        this.ebsResult = builder.ebsResult;
        this.ebsCause = builder.ebsCause;
        this.ebsRequestId = builder.ebsRequestId;
        this.xRayFaultPercent = builder.xRayFaultPercent;
        this.xRayThrottlePercent = builder.xRayThrottlePercent;
        this.xRayErrorPercent = builder.xRayErrorPercent;
        this.xRayRequestCount = builder.xRayRequestCount;
        this.xRayRequestAverageLatency = builder.xRayRequestAverageLatency;
        this.xRayNodeName = builder.xRayNodeName;
        this.xRayNodeType = builder.xRayNodeType;
    }

    /**
     * <p>
     * The ID of the observation type.
     * </p>
     * 
     * @return The ID of the observation type.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time when the observation was first detected, in epoch seconds.
     * </p>
     * 
     * @return The time when the observation was first detected, in epoch seconds.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the observation ended, in epoch seconds.
     * </p>
     * 
     * @return The time when the observation ended, in epoch seconds.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The source type of the observation.
     * </p>
     * 
     * @return The source type of the observation.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The source resource ARN of the observation.
     * </p>
     * 
     * @return The source resource ARN of the observation.
     */
    public final String sourceARN() {
        return sourceARN;
    }

    /**
     * <p>
     * The log group name.
     * </p>
     * 
     * @return The log group name.
     */
    public final String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
     * </p>
     * 
     * @return The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
     */
    public final Instant lineTime() {
        return lineTime;
    }

    /**
     * <p>
     * The log text of the observation.
     * </p>
     * 
     * @return The log text of the observation.
     */
    public final String logText() {
        return logText;
    }

    /**
     * <p>
     * The log filter of the observation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFilter} will
     * return {@link LogFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFilterAsString}.
     * </p>
     * 
     * @return The log filter of the observation.
     * @see LogFilter
     */
    public final LogFilter logFilter() {
        return LogFilter.fromValue(logFilter);
    }

    /**
     * <p>
     * The log filter of the observation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFilter} will
     * return {@link LogFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFilterAsString}.
     * </p>
     * 
     * @return The log filter of the observation.
     * @see LogFilter
     */
    public final String logFilterAsString() {
        return logFilter;
    }

    /**
     * <p>
     * The namespace of the observation metric.
     * </p>
     * 
     * @return The namespace of the observation metric.
     */
    public final String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The name of the observation metric.
     * </p>
     * 
     * @return The name of the observation metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The unit of the source observation metric.
     * </p>
     * 
     * @return The unit of the source observation metric.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The value of the source observation metric.
     * </p>
     * 
     * @return The value of the source observation metric.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * The ID of the CloudWatch Event-based observation related to the detected problem.
     * </p>
     * 
     * @return The ID of the CloudWatch Event-based observation related to the detected problem.
     */
    public final String cloudWatchEventId() {
        return cloudWatchEventId;
    }

    /**
     * <p>
     * The source of the CloudWatch Event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cloudWatchEventSource} will return {@link CloudWatchEventSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cloudWatchEventSourceAsString}.
     * </p>
     * 
     * @return The source of the CloudWatch Event.
     * @see CloudWatchEventSource
     */
    public final CloudWatchEventSource cloudWatchEventSource() {
        return CloudWatchEventSource.fromValue(cloudWatchEventSource);
    }

    /**
     * <p>
     * The source of the CloudWatch Event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cloudWatchEventSource} will return {@link CloudWatchEventSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cloudWatchEventSourceAsString}.
     * </p>
     * 
     * @return The source of the CloudWatch Event.
     * @see CloudWatchEventSource
     */
    public final String cloudWatchEventSourceAsString() {
        return cloudWatchEventSource;
    }

    /**
     * <p>
     * The detail type of the CloudWatch Event-based observation, for example,
     * <code>EC2 Instance State-change Notification</code>.
     * </p>
     * 
     * @return The detail type of the CloudWatch Event-based observation, for example,
     *         <code>EC2 Instance State-change Notification</code>.
     */
    public final String cloudWatchEventDetailType() {
        return cloudWatchEventDetailType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Health Event-based observation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Health Event-based observation.
     */
    public final String healthEventArn() {
        return healthEventArn;
    }

    /**
     * <p>
     * The service to which the Health Event belongs, such as EC2.
     * </p>
     * 
     * @return The service to which the Health Event belongs, such as EC2.
     */
    public final String healthService() {
        return healthService;
    }

    /**
     * <p>
     * The type of the Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>.
     * </p>
     * 
     * @return The type of the Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>.
     */
    public final String healthEventTypeCode() {
        return healthEventTypeCode;
    }

    /**
     * <p>
     * The category of the Health event, such as <code>issue</code>.
     * </p>
     * 
     * @return The category of the Health event, such as <code>issue</code>.
     */
    public final String healthEventTypeCategory() {
        return healthEventTypeCategory;
    }

    /**
     * <p>
     * The description of the Health event provided by the service, such as Amazon EC2.
     * </p>
     * 
     * @return The description of the Health event provided by the service, such as Amazon EC2.
     */
    public final String healthEventDescription() {
        return healthEventDescription;
    }

    /**
     * <p>
     * The deployment ID of the CodeDeploy-based observation related to the detected problem.
     * </p>
     * 
     * @return The deployment ID of the CodeDeploy-based observation related to the detected problem.
     */
    public final String codeDeployDeploymentId() {
        return codeDeployDeploymentId;
    }

    /**
     * <p>
     * The deployment group to which the CodeDeploy deployment belongs.
     * </p>
     * 
     * @return The deployment group to which the CodeDeploy deployment belongs.
     */
    public final String codeDeployDeploymentGroup() {
        return codeDeployDeploymentGroup;
    }

    /**
     * <p>
     * The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>.
     * </p>
     * 
     * @return The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>.
     */
    public final String codeDeployState() {
        return codeDeployState;
    }

    /**
     * <p>
     * The CodeDeploy application to which the deployment belongs.
     * </p>
     * 
     * @return The CodeDeploy application to which the deployment belongs.
     */
    public final String codeDeployApplication() {
        return codeDeployApplication;
    }

    /**
     * <p>
     * The instance group to which the CodeDeploy instance belongs.
     * </p>
     * 
     * @return The instance group to which the CodeDeploy instance belongs.
     */
    public final String codeDeployInstanceGroupId() {
        return codeDeployInstanceGroupId;
    }

    /**
     * <p>
     * The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>.
     * </p>
     * 
     * @return The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>.
     */
    public final String ec2State() {
        return ec2State;
    }

    /**
     * <p>
     * The category of an RDS event.
     * </p>
     * 
     * @return The category of an RDS event.
     */
    public final String rdsEventCategories() {
        return rdsEventCategories;
    }

    /**
     * <p>
     * The message of an RDS event.
     * </p>
     * 
     * @return The message of an RDS event.
     */
    public final String rdsEventMessage() {
        return rdsEventMessage;
    }

    /**
     * <p>
     * The name of the S3 CloudWatch Event-based observation.
     * </p>
     * 
     * @return The name of the S3 CloudWatch Event-based observation.
     */
    public final String s3EventName() {
        return s3EventName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the step function execution-based observation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the step function execution-based observation.
     */
    public final String statesExecutionArn() {
        return statesExecutionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the step function-based observation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the step function-based observation.
     */
    public final String statesArn() {
        return statesArn;
    }

    /**
     * <p>
     * The status of the step function-related observation.
     * </p>
     * 
     * @return The status of the step function-related observation.
     */
    public final String statesStatus() {
        return statesStatus;
    }

    /**
     * <p>
     * The input to the step function-based observation.
     * </p>
     * 
     * @return The input to the step function-based observation.
     */
    public final String statesInput() {
        return statesInput;
    }

    /**
     * <p>
     * The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or
     * <code>attachVolume</code>.
     * </p>
     * 
     * @return The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or
     *         <code>attachVolume</code>.
     */
    public final String ebsEvent() {
        return ebsEvent;
    }

    /**
     * <p>
     * The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>.
     * </p>
     * 
     * @return The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>.
     */
    public final String ebsResult() {
        return ebsResult;
    }

    /**
     * <p>
     * The cause of an EBS CloudWatch event.
     * </p>
     * 
     * @return The cause of an EBS CloudWatch event.
     */
    public final String ebsCause() {
        return ebsCause;
    }

    /**
     * <p>
     * The request ID of an EBS CloudWatch event.
     * </p>
     * 
     * @return The request ID of an EBS CloudWatch event.
     */
    public final String ebsRequestId() {
        return ebsRequestId;
    }

    /**
     * <p>
     * The X-Ray request fault percentage for this node.
     * </p>
     * 
     * @return The X-Ray request fault percentage for this node.
     */
    public final Integer xRayFaultPercent() {
        return xRayFaultPercent;
    }

    /**
     * <p>
     * The X-Ray request throttle percentage for this node.
     * </p>
     * 
     * @return The X-Ray request throttle percentage for this node.
     */
    public final Integer xRayThrottlePercent() {
        return xRayThrottlePercent;
    }

    /**
     * <p>
     * The X-Ray request error percentage for this node.
     * </p>
     * 
     * @return The X-Ray request error percentage for this node.
     */
    public final Integer xRayErrorPercent() {
        return xRayErrorPercent;
    }

    /**
     * <p>
     * The X-Ray request count for this node.
     * </p>
     * 
     * @return The X-Ray request count for this node.
     */
    public final Integer xRayRequestCount() {
        return xRayRequestCount;
    }

    /**
     * <p>
     * The X-Ray node request average latency for this node.
     * </p>
     * 
     * @return The X-Ray node request average latency for this node.
     */
    public final Long xRayRequestAverageLatency() {
        return xRayRequestAverageLatency;
    }

    /**
     * <p>
     * The name of the X-Ray node.
     * </p>
     * 
     * @return The name of the X-Ray node.
     */
    public final String xRayNodeName() {
        return xRayNodeName;
    }

    /**
     * <p>
     * The type of the X-Ray node.
     * </p>
     * 
     * @return The type of the X-Ray node.
     */
    public final String xRayNodeType() {
        return xRayNodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(lineTime());
        hashCode = 31 * hashCode + Objects.hashCode(logText());
        hashCode = 31 * hashCode + Objects.hashCode(logFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEventId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEventDetailType());
        hashCode = 31 * hashCode + Objects.hashCode(healthEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(healthService());
        hashCode = 31 * hashCode + Objects.hashCode(healthEventTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(healthEventTypeCategory());
        hashCode = 31 * hashCode + Objects.hashCode(healthEventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployDeploymentGroup());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployState());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployApplication());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployInstanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2State());
        hashCode = 31 * hashCode + Objects.hashCode(rdsEventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(rdsEventMessage());
        hashCode = 31 * hashCode + Objects.hashCode(s3EventName());
        hashCode = 31 * hashCode + Objects.hashCode(statesExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statesArn());
        hashCode = 31 * hashCode + Objects.hashCode(statesStatus());
        hashCode = 31 * hashCode + Objects.hashCode(statesInput());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEvent());
        hashCode = 31 * hashCode + Objects.hashCode(ebsResult());
        hashCode = 31 * hashCode + Objects.hashCode(ebsCause());
        hashCode = 31 * hashCode + Objects.hashCode(ebsRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(xRayFaultPercent());
        hashCode = 31 * hashCode + Objects.hashCode(xRayThrottlePercent());
        hashCode = 31 * hashCode + Objects.hashCode(xRayErrorPercent());
        hashCode = 31 * hashCode + Objects.hashCode(xRayRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(xRayRequestAverageLatency());
        hashCode = 31 * hashCode + Objects.hashCode(xRayNodeName());
        hashCode = 31 * hashCode + Objects.hashCode(xRayNodeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(sourceType(), other.sourceType())
                && Objects.equals(sourceARN(), other.sourceARN()) && Objects.equals(logGroup(), other.logGroup())
                && Objects.equals(lineTime(), other.lineTime()) && Objects.equals(logText(), other.logText())
                && Objects.equals(logFilterAsString(), other.logFilterAsString())
                && Objects.equals(metricNamespace(), other.metricNamespace()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(unit(), other.unit()) && Objects.equals(value(), other.value())
                && Objects.equals(cloudWatchEventId(), other.cloudWatchEventId())
                && Objects.equals(cloudWatchEventSourceAsString(), other.cloudWatchEventSourceAsString())
                && Objects.equals(cloudWatchEventDetailType(), other.cloudWatchEventDetailType())
                && Objects.equals(healthEventArn(), other.healthEventArn())
                && Objects.equals(healthService(), other.healthService())
                && Objects.equals(healthEventTypeCode(), other.healthEventTypeCode())
                && Objects.equals(healthEventTypeCategory(), other.healthEventTypeCategory())
                && Objects.equals(healthEventDescription(), other.healthEventDescription())
                && Objects.equals(codeDeployDeploymentId(), other.codeDeployDeploymentId())
                && Objects.equals(codeDeployDeploymentGroup(), other.codeDeployDeploymentGroup())
                && Objects.equals(codeDeployState(), other.codeDeployState())
                && Objects.equals(codeDeployApplication(), other.codeDeployApplication())
                && Objects.equals(codeDeployInstanceGroupId(), other.codeDeployInstanceGroupId())
                && Objects.equals(ec2State(), other.ec2State())
                && Objects.equals(rdsEventCategories(), other.rdsEventCategories())
                && Objects.equals(rdsEventMessage(), other.rdsEventMessage())
                && Objects.equals(s3EventName(), other.s3EventName())
                && Objects.equals(statesExecutionArn(), other.statesExecutionArn())
                && Objects.equals(statesArn(), other.statesArn()) && Objects.equals(statesStatus(), other.statesStatus())
                && Objects.equals(statesInput(), other.statesInput()) && Objects.equals(ebsEvent(), other.ebsEvent())
                && Objects.equals(ebsResult(), other.ebsResult()) && Objects.equals(ebsCause(), other.ebsCause())
                && Objects.equals(ebsRequestId(), other.ebsRequestId())
                && Objects.equals(xRayFaultPercent(), other.xRayFaultPercent())
                && Objects.equals(xRayThrottlePercent(), other.xRayThrottlePercent())
                && Objects.equals(xRayErrorPercent(), other.xRayErrorPercent())
                && Objects.equals(xRayRequestCount(), other.xRayRequestCount())
                && Objects.equals(xRayRequestAverageLatency(), other.xRayRequestAverageLatency())
                && Objects.equals(xRayNodeName(), other.xRayNodeName()) && Objects.equals(xRayNodeType(), other.xRayNodeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Observation").add("Id", id()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("SourceType", sourceType()).add("SourceARN", sourceARN()).add("LogGroup", logGroup())
                .add("LineTime", lineTime()).add("LogText", logText()).add("LogFilter", logFilterAsString())
                .add("MetricNamespace", metricNamespace()).add("MetricName", metricName()).add("Unit", unit())
                .add("Value", value()).add("CloudWatchEventId", cloudWatchEventId())
                .add("CloudWatchEventSource", cloudWatchEventSourceAsString())
                .add("CloudWatchEventDetailType", cloudWatchEventDetailType()).add("HealthEventArn", healthEventArn())
                .add("HealthService", healthService()).add("HealthEventTypeCode", healthEventTypeCode())
                .add("HealthEventTypeCategory", healthEventTypeCategory())
                .add("HealthEventDescription", healthEventDescription()).add("CodeDeployDeploymentId", codeDeployDeploymentId())
                .add("CodeDeployDeploymentGroup", codeDeployDeploymentGroup()).add("CodeDeployState", codeDeployState())
                .add("CodeDeployApplication", codeDeployApplication())
                .add("CodeDeployInstanceGroupId", codeDeployInstanceGroupId()).add("Ec2State", ec2State())
                .add("RdsEventCategories", rdsEventCategories()).add("RdsEventMessage", rdsEventMessage())
                .add("S3EventName", s3EventName()).add("StatesExecutionArn", statesExecutionArn()).add("StatesArn", statesArn())
                .add("StatesStatus", statesStatus()).add("StatesInput", statesInput()).add("EbsEvent", ebsEvent())
                .add("EbsResult", ebsResult()).add("EbsCause", ebsCause()).add("EbsRequestId", ebsRequestId())
                .add("XRayFaultPercent", xRayFaultPercent()).add("XRayThrottlePercent", xRayThrottlePercent())
                .add("XRayErrorPercent", xRayErrorPercent()).add("XRayRequestCount", xRayRequestCount())
                .add("XRayRequestAverageLatency", xRayRequestAverageLatency()).add("XRayNodeName", xRayNodeName())
                .add("XRayNodeType", xRayNodeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceARN":
            return Optional.ofNullable(clazz.cast(sourceARN()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LineTime":
            return Optional.ofNullable(clazz.cast(lineTime()));
        case "LogText":
            return Optional.ofNullable(clazz.cast(logText()));
        case "LogFilter":
            return Optional.ofNullable(clazz.cast(logFilterAsString()));
        case "MetricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "CloudWatchEventId":
            return Optional.ofNullable(clazz.cast(cloudWatchEventId()));
        case "CloudWatchEventSource":
            return Optional.ofNullable(clazz.cast(cloudWatchEventSourceAsString()));
        case "CloudWatchEventDetailType":
            return Optional.ofNullable(clazz.cast(cloudWatchEventDetailType()));
        case "HealthEventArn":
            return Optional.ofNullable(clazz.cast(healthEventArn()));
        case "HealthService":
            return Optional.ofNullable(clazz.cast(healthService()));
        case "HealthEventTypeCode":
            return Optional.ofNullable(clazz.cast(healthEventTypeCode()));
        case "HealthEventTypeCategory":
            return Optional.ofNullable(clazz.cast(healthEventTypeCategory()));
        case "HealthEventDescription":
            return Optional.ofNullable(clazz.cast(healthEventDescription()));
        case "CodeDeployDeploymentId":
            return Optional.ofNullable(clazz.cast(codeDeployDeploymentId()));
        case "CodeDeployDeploymentGroup":
            return Optional.ofNullable(clazz.cast(codeDeployDeploymentGroup()));
        case "CodeDeployState":
            return Optional.ofNullable(clazz.cast(codeDeployState()));
        case "CodeDeployApplication":
            return Optional.ofNullable(clazz.cast(codeDeployApplication()));
        case "CodeDeployInstanceGroupId":
            return Optional.ofNullable(clazz.cast(codeDeployInstanceGroupId()));
        case "Ec2State":
            return Optional.ofNullable(clazz.cast(ec2State()));
        case "RdsEventCategories":
            return Optional.ofNullable(clazz.cast(rdsEventCategories()));
        case "RdsEventMessage":
            return Optional.ofNullable(clazz.cast(rdsEventMessage()));
        case "S3EventName":
            return Optional.ofNullable(clazz.cast(s3EventName()));
        case "StatesExecutionArn":
            return Optional.ofNullable(clazz.cast(statesExecutionArn()));
        case "StatesArn":
            return Optional.ofNullable(clazz.cast(statesArn()));
        case "StatesStatus":
            return Optional.ofNullable(clazz.cast(statesStatus()));
        case "StatesInput":
            return Optional.ofNullable(clazz.cast(statesInput()));
        case "EbsEvent":
            return Optional.ofNullable(clazz.cast(ebsEvent()));
        case "EbsResult":
            return Optional.ofNullable(clazz.cast(ebsResult()));
        case "EbsCause":
            return Optional.ofNullable(clazz.cast(ebsCause()));
        case "EbsRequestId":
            return Optional.ofNullable(clazz.cast(ebsRequestId()));
        case "XRayFaultPercent":
            return Optional.ofNullable(clazz.cast(xRayFaultPercent()));
        case "XRayThrottlePercent":
            return Optional.ofNullable(clazz.cast(xRayThrottlePercent()));
        case "XRayErrorPercent":
            return Optional.ofNullable(clazz.cast(xRayErrorPercent()));
        case "XRayRequestCount":
            return Optional.ofNullable(clazz.cast(xRayRequestCount()));
        case "XRayRequestAverageLatency":
            return Optional.ofNullable(clazz.cast(xRayRequestAverageLatency()));
        case "XRayNodeName":
            return Optional.ofNullable(clazz.cast(xRayNodeName()));
        case "XRayNodeType":
            return Optional.ofNullable(clazz.cast(xRayNodeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceARN", SOURCE_ARN_FIELD);
        map.put("LogGroup", LOG_GROUP_FIELD);
        map.put("LineTime", LINE_TIME_FIELD);
        map.put("LogText", LOG_TEXT_FIELD);
        map.put("LogFilter", LOG_FILTER_FIELD);
        map.put("MetricNamespace", METRIC_NAMESPACE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("CloudWatchEventId", CLOUD_WATCH_EVENT_ID_FIELD);
        map.put("CloudWatchEventSource", CLOUD_WATCH_EVENT_SOURCE_FIELD);
        map.put("CloudWatchEventDetailType", CLOUD_WATCH_EVENT_DETAIL_TYPE_FIELD);
        map.put("HealthEventArn", HEALTH_EVENT_ARN_FIELD);
        map.put("HealthService", HEALTH_SERVICE_FIELD);
        map.put("HealthEventTypeCode", HEALTH_EVENT_TYPE_CODE_FIELD);
        map.put("HealthEventTypeCategory", HEALTH_EVENT_TYPE_CATEGORY_FIELD);
        map.put("HealthEventDescription", HEALTH_EVENT_DESCRIPTION_FIELD);
        map.put("CodeDeployDeploymentId", CODE_DEPLOY_DEPLOYMENT_ID_FIELD);
        map.put("CodeDeployDeploymentGroup", CODE_DEPLOY_DEPLOYMENT_GROUP_FIELD);
        map.put("CodeDeployState", CODE_DEPLOY_STATE_FIELD);
        map.put("CodeDeployApplication", CODE_DEPLOY_APPLICATION_FIELD);
        map.put("CodeDeployInstanceGroupId", CODE_DEPLOY_INSTANCE_GROUP_ID_FIELD);
        map.put("Ec2State", EC2_STATE_FIELD);
        map.put("RdsEventCategories", RDS_EVENT_CATEGORIES_FIELD);
        map.put("RdsEventMessage", RDS_EVENT_MESSAGE_FIELD);
        map.put("S3EventName", S3_EVENT_NAME_FIELD);
        map.put("StatesExecutionArn", STATES_EXECUTION_ARN_FIELD);
        map.put("StatesArn", STATES_ARN_FIELD);
        map.put("StatesStatus", STATES_STATUS_FIELD);
        map.put("StatesInput", STATES_INPUT_FIELD);
        map.put("EbsEvent", EBS_EVENT_FIELD);
        map.put("EbsResult", EBS_RESULT_FIELD);
        map.put("EbsCause", EBS_CAUSE_FIELD);
        map.put("EbsRequestId", EBS_REQUEST_ID_FIELD);
        map.put("XRayFaultPercent", X_RAY_FAULT_PERCENT_FIELD);
        map.put("XRayThrottlePercent", X_RAY_THROTTLE_PERCENT_FIELD);
        map.put("XRayErrorPercent", X_RAY_ERROR_PERCENT_FIELD);
        map.put("XRayRequestCount", X_RAY_REQUEST_COUNT_FIELD);
        map.put("XRayRequestAverageLatency", X_RAY_REQUEST_AVERAGE_LATENCY_FIELD);
        map.put("XRayNodeName", X_RAY_NODE_NAME_FIELD);
        map.put("XRayNodeType", X_RAY_NODE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Observation> {
        /**
         * <p>
         * The ID of the observation type.
         * </p>
         * 
         * @param id
         *        The ID of the observation type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time when the observation was first detected, in epoch seconds.
         * </p>
         * 
         * @param startTime
         *        The time when the observation was first detected, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the observation ended, in epoch seconds.
         * </p>
         * 
         * @param endTime
         *        The time when the observation ended, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The source type of the observation.
         * </p>
         * 
         * @param sourceType
         *        The source type of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source resource ARN of the observation.
         * </p>
         * 
         * @param sourceARN
         *        The source resource ARN of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceARN(String sourceARN);

        /**
         * <p>
         * The log group name.
         * </p>
         * 
         * @param logGroup
         *        The log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         * </p>
         * 
         * @param lineTime
         *        The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineTime(Instant lineTime);

        /**
         * <p>
         * The log text of the observation.
         * </p>
         * 
         * @param logText
         *        The log text of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logText(String logText);

        /**
         * <p>
         * The log filter of the observation.
         * </p>
         * 
         * @param logFilter
         *        The log filter of the observation.
         * @see LogFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFilter
         */
        Builder logFilter(String logFilter);

        /**
         * <p>
         * The log filter of the observation.
         * </p>
         * 
         * @param logFilter
         *        The log filter of the observation.
         * @see LogFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFilter
         */
        Builder logFilter(LogFilter logFilter);

        /**
         * <p>
         * The namespace of the observation metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The name of the observation metric.
         * </p>
         * 
         * @param metricName
         *        The name of the observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The unit of the source observation metric.
         * </p>
         * 
         * @param unit
         *        The unit of the source observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The value of the source observation metric.
         * </p>
         * 
         * @param value
         *        The value of the source observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The ID of the CloudWatch Event-based observation related to the detected problem.
         * </p>
         * 
         * @param cloudWatchEventId
         *        The ID of the CloudWatch Event-based observation related to the detected problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchEventId(String cloudWatchEventId);

        /**
         * <p>
         * The source of the CloudWatch Event.
         * </p>
         * 
         * @param cloudWatchEventSource
         *        The source of the CloudWatch Event.
         * @see CloudWatchEventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchEventSource
         */
        Builder cloudWatchEventSource(String cloudWatchEventSource);

        /**
         * <p>
         * The source of the CloudWatch Event.
         * </p>
         * 
         * @param cloudWatchEventSource
         *        The source of the CloudWatch Event.
         * @see CloudWatchEventSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchEventSource
         */
        Builder cloudWatchEventSource(CloudWatchEventSource cloudWatchEventSource);

        /**
         * <p>
         * The detail type of the CloudWatch Event-based observation, for example,
         * <code>EC2 Instance State-change Notification</code>.
         * </p>
         * 
         * @param cloudWatchEventDetailType
         *        The detail type of the CloudWatch Event-based observation, for example,
         *        <code>EC2 Instance State-change Notification</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchEventDetailType(String cloudWatchEventDetailType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Health Event-based observation.
         * </p>
         * 
         * @param healthEventArn
         *        The Amazon Resource Name (ARN) of the Health Event-based observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthEventArn(String healthEventArn);

        /**
         * <p>
         * The service to which the Health Event belongs, such as EC2.
         * </p>
         * 
         * @param healthService
         *        The service to which the Health Event belongs, such as EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthService(String healthService);

        /**
         * <p>
         * The type of the Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>.
         * </p>
         * 
         * @param healthEventTypeCode
         *        The type of the Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthEventTypeCode(String healthEventTypeCode);

        /**
         * <p>
         * The category of the Health event, such as <code>issue</code>.
         * </p>
         * 
         * @param healthEventTypeCategory
         *        The category of the Health event, such as <code>issue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthEventTypeCategory(String healthEventTypeCategory);

        /**
         * <p>
         * The description of the Health event provided by the service, such as Amazon EC2.
         * </p>
         * 
         * @param healthEventDescription
         *        The description of the Health event provided by the service, such as Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthEventDescription(String healthEventDescription);

        /**
         * <p>
         * The deployment ID of the CodeDeploy-based observation related to the detected problem.
         * </p>
         * 
         * @param codeDeployDeploymentId
         *        The deployment ID of the CodeDeploy-based observation related to the detected problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployDeploymentId(String codeDeployDeploymentId);

        /**
         * <p>
         * The deployment group to which the CodeDeploy deployment belongs.
         * </p>
         * 
         * @param codeDeployDeploymentGroup
         *        The deployment group to which the CodeDeploy deployment belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployDeploymentGroup(String codeDeployDeploymentGroup);

        /**
         * <p>
         * The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>.
         * </p>
         * 
         * @param codeDeployState
         *        The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployState(String codeDeployState);

        /**
         * <p>
         * The CodeDeploy application to which the deployment belongs.
         * </p>
         * 
         * @param codeDeployApplication
         *        The CodeDeploy application to which the deployment belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployApplication(String codeDeployApplication);

        /**
         * <p>
         * The instance group to which the CodeDeploy instance belongs.
         * </p>
         * 
         * @param codeDeployInstanceGroupId
         *        The instance group to which the CodeDeploy instance belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployInstanceGroupId(String codeDeployInstanceGroupId);

        /**
         * <p>
         * The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>.
         * </p>
         * 
         * @param ec2State
         *        The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2State(String ec2State);

        /**
         * <p>
         * The category of an RDS event.
         * </p>
         * 
         * @param rdsEventCategories
         *        The category of an RDS event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsEventCategories(String rdsEventCategories);

        /**
         * <p>
         * The message of an RDS event.
         * </p>
         * 
         * @param rdsEventMessage
         *        The message of an RDS event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsEventMessage(String rdsEventMessage);

        /**
         * <p>
         * The name of the S3 CloudWatch Event-based observation.
         * </p>
         * 
         * @param s3EventName
         *        The name of the S3 CloudWatch Event-based observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3EventName(String s3EventName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the step function execution-based observation.
         * </p>
         * 
         * @param statesExecutionArn
         *        The Amazon Resource Name (ARN) of the step function execution-based observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesExecutionArn(String statesExecutionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the step function-based observation.
         * </p>
         * 
         * @param statesArn
         *        The Amazon Resource Name (ARN) of the step function-based observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesArn(String statesArn);

        /**
         * <p>
         * The status of the step function-related observation.
         * </p>
         * 
         * @param statesStatus
         *        The status of the step function-related observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesStatus(String statesStatus);

        /**
         * <p>
         * The input to the step function-based observation.
         * </p>
         * 
         * @param statesInput
         *        The input to the step function-based observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesInput(String statesInput);

        /**
         * <p>
         * The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or
         * <code>attachVolume</code>.
         * </p>
         * 
         * @param ebsEvent
         *        The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or
         *        <code>attachVolume</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEvent(String ebsEvent);

        /**
         * <p>
         * The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>.
         * </p>
         * 
         * @param ebsResult
         *        The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsResult(String ebsResult);

        /**
         * <p>
         * The cause of an EBS CloudWatch event.
         * </p>
         * 
         * @param ebsCause
         *        The cause of an EBS CloudWatch event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsCause(String ebsCause);

        /**
         * <p>
         * The request ID of an EBS CloudWatch event.
         * </p>
         * 
         * @param ebsRequestId
         *        The request ID of an EBS CloudWatch event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsRequestId(String ebsRequestId);

        /**
         * <p>
         * The X-Ray request fault percentage for this node.
         * </p>
         * 
         * @param xRayFaultPercent
         *        The X-Ray request fault percentage for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayFaultPercent(Integer xRayFaultPercent);

        /**
         * <p>
         * The X-Ray request throttle percentage for this node.
         * </p>
         * 
         * @param xRayThrottlePercent
         *        The X-Ray request throttle percentage for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayThrottlePercent(Integer xRayThrottlePercent);

        /**
         * <p>
         * The X-Ray request error percentage for this node.
         * </p>
         * 
         * @param xRayErrorPercent
         *        The X-Ray request error percentage for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayErrorPercent(Integer xRayErrorPercent);

        /**
         * <p>
         * The X-Ray request count for this node.
         * </p>
         * 
         * @param xRayRequestCount
         *        The X-Ray request count for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayRequestCount(Integer xRayRequestCount);

        /**
         * <p>
         * The X-Ray node request average latency for this node.
         * </p>
         * 
         * @param xRayRequestAverageLatency
         *        The X-Ray node request average latency for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayRequestAverageLatency(Long xRayRequestAverageLatency);

        /**
         * <p>
         * The name of the X-Ray node.
         * </p>
         * 
         * @param xRayNodeName
         *        The name of the X-Ray node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayNodeName(String xRayNodeName);

        /**
         * <p>
         * The type of the X-Ray node.
         * </p>
         * 
         * @param xRayNodeType
         *        The type of the X-Ray node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xRayNodeType(String xRayNodeType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant startTime;

        private Instant endTime;

        private String sourceType;

        private String sourceARN;

        private String logGroup;

        private Instant lineTime;

        private String logText;

        private String logFilter;

        private String metricNamespace;

        private String metricName;

        private String unit;

        private Double value;

        private String cloudWatchEventId;

        private String cloudWatchEventSource;

        private String cloudWatchEventDetailType;

        private String healthEventArn;

        private String healthService;

        private String healthEventTypeCode;

        private String healthEventTypeCategory;

        private String healthEventDescription;

        private String codeDeployDeploymentId;

        private String codeDeployDeploymentGroup;

        private String codeDeployState;

        private String codeDeployApplication;

        private String codeDeployInstanceGroupId;

        private String ec2State;

        private String rdsEventCategories;

        private String rdsEventMessage;

        private String s3EventName;

        private String statesExecutionArn;

        private String statesArn;

        private String statesStatus;

        private String statesInput;

        private String ebsEvent;

        private String ebsResult;

        private String ebsCause;

        private String ebsRequestId;

        private Integer xRayFaultPercent;

        private Integer xRayThrottlePercent;

        private Integer xRayErrorPercent;

        private Integer xRayRequestCount;

        private Long xRayRequestAverageLatency;

        private String xRayNodeName;

        private String xRayNodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            id(model.id);
            startTime(model.startTime);
            endTime(model.endTime);
            sourceType(model.sourceType);
            sourceARN(model.sourceARN);
            logGroup(model.logGroup);
            lineTime(model.lineTime);
            logText(model.logText);
            logFilter(model.logFilter);
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            unit(model.unit);
            value(model.value);
            cloudWatchEventId(model.cloudWatchEventId);
            cloudWatchEventSource(model.cloudWatchEventSource);
            cloudWatchEventDetailType(model.cloudWatchEventDetailType);
            healthEventArn(model.healthEventArn);
            healthService(model.healthService);
            healthEventTypeCode(model.healthEventTypeCode);
            healthEventTypeCategory(model.healthEventTypeCategory);
            healthEventDescription(model.healthEventDescription);
            codeDeployDeploymentId(model.codeDeployDeploymentId);
            codeDeployDeploymentGroup(model.codeDeployDeploymentGroup);
            codeDeployState(model.codeDeployState);
            codeDeployApplication(model.codeDeployApplication);
            codeDeployInstanceGroupId(model.codeDeployInstanceGroupId);
            ec2State(model.ec2State);
            rdsEventCategories(model.rdsEventCategories);
            rdsEventMessage(model.rdsEventMessage);
            s3EventName(model.s3EventName);
            statesExecutionArn(model.statesExecutionArn);
            statesArn(model.statesArn);
            statesStatus(model.statesStatus);
            statesInput(model.statesInput);
            ebsEvent(model.ebsEvent);
            ebsResult(model.ebsResult);
            ebsCause(model.ebsCause);
            ebsRequestId(model.ebsRequestId);
            xRayFaultPercent(model.xRayFaultPercent);
            xRayThrottlePercent(model.xRayThrottlePercent);
            xRayErrorPercent(model.xRayErrorPercent);
            xRayRequestCount(model.xRayRequestCount);
            xRayRequestAverageLatency(model.xRayRequestAverageLatency);
            xRayNodeName(model.xRayNodeName);
            xRayNodeType(model.xRayNodeType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getSourceARN() {
            return sourceARN;
        }

        public final void setSourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
        }

        @Override
        public final Builder sourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
            return this;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final Instant getLineTime() {
            return lineTime;
        }

        public final void setLineTime(Instant lineTime) {
            this.lineTime = lineTime;
        }

        @Override
        public final Builder lineTime(Instant lineTime) {
            this.lineTime = lineTime;
            return this;
        }

        public final String getLogText() {
            return logText;
        }

        public final void setLogText(String logText) {
            this.logText = logText;
        }

        @Override
        public final Builder logText(String logText) {
            this.logText = logText;
            return this;
        }

        public final String getLogFilter() {
            return logFilter;
        }

        public final void setLogFilter(String logFilter) {
            this.logFilter = logFilter;
        }

        @Override
        public final Builder logFilter(String logFilter) {
            this.logFilter = logFilter;
            return this;
        }

        @Override
        public final Builder logFilter(LogFilter logFilter) {
            this.logFilter(logFilter == null ? null : logFilter.toString());
            return this;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getCloudWatchEventId() {
            return cloudWatchEventId;
        }

        public final void setCloudWatchEventId(String cloudWatchEventId) {
            this.cloudWatchEventId = cloudWatchEventId;
        }

        @Override
        public final Builder cloudWatchEventId(String cloudWatchEventId) {
            this.cloudWatchEventId = cloudWatchEventId;
            return this;
        }

        public final String getCloudWatchEventSource() {
            return cloudWatchEventSource;
        }

        public final void setCloudWatchEventSource(String cloudWatchEventSource) {
            this.cloudWatchEventSource = cloudWatchEventSource;
        }

        @Override
        public final Builder cloudWatchEventSource(String cloudWatchEventSource) {
            this.cloudWatchEventSource = cloudWatchEventSource;
            return this;
        }

        @Override
        public final Builder cloudWatchEventSource(CloudWatchEventSource cloudWatchEventSource) {
            this.cloudWatchEventSource(cloudWatchEventSource == null ? null : cloudWatchEventSource.toString());
            return this;
        }

        public final String getCloudWatchEventDetailType() {
            return cloudWatchEventDetailType;
        }

        public final void setCloudWatchEventDetailType(String cloudWatchEventDetailType) {
            this.cloudWatchEventDetailType = cloudWatchEventDetailType;
        }

        @Override
        public final Builder cloudWatchEventDetailType(String cloudWatchEventDetailType) {
            this.cloudWatchEventDetailType = cloudWatchEventDetailType;
            return this;
        }

        public final String getHealthEventArn() {
            return healthEventArn;
        }

        public final void setHealthEventArn(String healthEventArn) {
            this.healthEventArn = healthEventArn;
        }

        @Override
        public final Builder healthEventArn(String healthEventArn) {
            this.healthEventArn = healthEventArn;
            return this;
        }

        public final String getHealthService() {
            return healthService;
        }

        public final void setHealthService(String healthService) {
            this.healthService = healthService;
        }

        @Override
        public final Builder healthService(String healthService) {
            this.healthService = healthService;
            return this;
        }

        public final String getHealthEventTypeCode() {
            return healthEventTypeCode;
        }

        public final void setHealthEventTypeCode(String healthEventTypeCode) {
            this.healthEventTypeCode = healthEventTypeCode;
        }

        @Override
        public final Builder healthEventTypeCode(String healthEventTypeCode) {
            this.healthEventTypeCode = healthEventTypeCode;
            return this;
        }

        public final String getHealthEventTypeCategory() {
            return healthEventTypeCategory;
        }

        public final void setHealthEventTypeCategory(String healthEventTypeCategory) {
            this.healthEventTypeCategory = healthEventTypeCategory;
        }

        @Override
        public final Builder healthEventTypeCategory(String healthEventTypeCategory) {
            this.healthEventTypeCategory = healthEventTypeCategory;
            return this;
        }

        public final String getHealthEventDescription() {
            return healthEventDescription;
        }

        public final void setHealthEventDescription(String healthEventDescription) {
            this.healthEventDescription = healthEventDescription;
        }

        @Override
        public final Builder healthEventDescription(String healthEventDescription) {
            this.healthEventDescription = healthEventDescription;
            return this;
        }

        public final String getCodeDeployDeploymentId() {
            return codeDeployDeploymentId;
        }

        public final void setCodeDeployDeploymentId(String codeDeployDeploymentId) {
            this.codeDeployDeploymentId = codeDeployDeploymentId;
        }

        @Override
        public final Builder codeDeployDeploymentId(String codeDeployDeploymentId) {
            this.codeDeployDeploymentId = codeDeployDeploymentId;
            return this;
        }

        public final String getCodeDeployDeploymentGroup() {
            return codeDeployDeploymentGroup;
        }

        public final void setCodeDeployDeploymentGroup(String codeDeployDeploymentGroup) {
            this.codeDeployDeploymentGroup = codeDeployDeploymentGroup;
        }

        @Override
        public final Builder codeDeployDeploymentGroup(String codeDeployDeploymentGroup) {
            this.codeDeployDeploymentGroup = codeDeployDeploymentGroup;
            return this;
        }

        public final String getCodeDeployState() {
            return codeDeployState;
        }

        public final void setCodeDeployState(String codeDeployState) {
            this.codeDeployState = codeDeployState;
        }

        @Override
        public final Builder codeDeployState(String codeDeployState) {
            this.codeDeployState = codeDeployState;
            return this;
        }

        public final String getCodeDeployApplication() {
            return codeDeployApplication;
        }

        public final void setCodeDeployApplication(String codeDeployApplication) {
            this.codeDeployApplication = codeDeployApplication;
        }

        @Override
        public final Builder codeDeployApplication(String codeDeployApplication) {
            this.codeDeployApplication = codeDeployApplication;
            return this;
        }

        public final String getCodeDeployInstanceGroupId() {
            return codeDeployInstanceGroupId;
        }

        public final void setCodeDeployInstanceGroupId(String codeDeployInstanceGroupId) {
            this.codeDeployInstanceGroupId = codeDeployInstanceGroupId;
        }

        @Override
        public final Builder codeDeployInstanceGroupId(String codeDeployInstanceGroupId) {
            this.codeDeployInstanceGroupId = codeDeployInstanceGroupId;
            return this;
        }

        public final String getEc2State() {
            return ec2State;
        }

        public final void setEc2State(String ec2State) {
            this.ec2State = ec2State;
        }

        @Override
        public final Builder ec2State(String ec2State) {
            this.ec2State = ec2State;
            return this;
        }

        public final String getRdsEventCategories() {
            return rdsEventCategories;
        }

        public final void setRdsEventCategories(String rdsEventCategories) {
            this.rdsEventCategories = rdsEventCategories;
        }

        @Override
        public final Builder rdsEventCategories(String rdsEventCategories) {
            this.rdsEventCategories = rdsEventCategories;
            return this;
        }

        public final String getRdsEventMessage() {
            return rdsEventMessage;
        }

        public final void setRdsEventMessage(String rdsEventMessage) {
            this.rdsEventMessage = rdsEventMessage;
        }

        @Override
        public final Builder rdsEventMessage(String rdsEventMessage) {
            this.rdsEventMessage = rdsEventMessage;
            return this;
        }

        public final String getS3EventName() {
            return s3EventName;
        }

        public final void setS3EventName(String s3EventName) {
            this.s3EventName = s3EventName;
        }

        @Override
        public final Builder s3EventName(String s3EventName) {
            this.s3EventName = s3EventName;
            return this;
        }

        public final String getStatesExecutionArn() {
            return statesExecutionArn;
        }

        public final void setStatesExecutionArn(String statesExecutionArn) {
            this.statesExecutionArn = statesExecutionArn;
        }

        @Override
        public final Builder statesExecutionArn(String statesExecutionArn) {
            this.statesExecutionArn = statesExecutionArn;
            return this;
        }

        public final String getStatesArn() {
            return statesArn;
        }

        public final void setStatesArn(String statesArn) {
            this.statesArn = statesArn;
        }

        @Override
        public final Builder statesArn(String statesArn) {
            this.statesArn = statesArn;
            return this;
        }

        public final String getStatesStatus() {
            return statesStatus;
        }

        public final void setStatesStatus(String statesStatus) {
            this.statesStatus = statesStatus;
        }

        @Override
        public final Builder statesStatus(String statesStatus) {
            this.statesStatus = statesStatus;
            return this;
        }

        public final String getStatesInput() {
            return statesInput;
        }

        public final void setStatesInput(String statesInput) {
            this.statesInput = statesInput;
        }

        @Override
        public final Builder statesInput(String statesInput) {
            this.statesInput = statesInput;
            return this;
        }

        public final String getEbsEvent() {
            return ebsEvent;
        }

        public final void setEbsEvent(String ebsEvent) {
            this.ebsEvent = ebsEvent;
        }

        @Override
        public final Builder ebsEvent(String ebsEvent) {
            this.ebsEvent = ebsEvent;
            return this;
        }

        public final String getEbsResult() {
            return ebsResult;
        }

        public final void setEbsResult(String ebsResult) {
            this.ebsResult = ebsResult;
        }

        @Override
        public final Builder ebsResult(String ebsResult) {
            this.ebsResult = ebsResult;
            return this;
        }

        public final String getEbsCause() {
            return ebsCause;
        }

        public final void setEbsCause(String ebsCause) {
            this.ebsCause = ebsCause;
        }

        @Override
        public final Builder ebsCause(String ebsCause) {
            this.ebsCause = ebsCause;
            return this;
        }

        public final String getEbsRequestId() {
            return ebsRequestId;
        }

        public final void setEbsRequestId(String ebsRequestId) {
            this.ebsRequestId = ebsRequestId;
        }

        @Override
        public final Builder ebsRequestId(String ebsRequestId) {
            this.ebsRequestId = ebsRequestId;
            return this;
        }

        public final Integer getXRayFaultPercent() {
            return xRayFaultPercent;
        }

        public final void setXRayFaultPercent(Integer xRayFaultPercent) {
            this.xRayFaultPercent = xRayFaultPercent;
        }

        @Override
        public final Builder xRayFaultPercent(Integer xRayFaultPercent) {
            this.xRayFaultPercent = xRayFaultPercent;
            return this;
        }

        public final Integer getXRayThrottlePercent() {
            return xRayThrottlePercent;
        }

        public final void setXRayThrottlePercent(Integer xRayThrottlePercent) {
            this.xRayThrottlePercent = xRayThrottlePercent;
        }

        @Override
        public final Builder xRayThrottlePercent(Integer xRayThrottlePercent) {
            this.xRayThrottlePercent = xRayThrottlePercent;
            return this;
        }

        public final Integer getXRayErrorPercent() {
            return xRayErrorPercent;
        }

        public final void setXRayErrorPercent(Integer xRayErrorPercent) {
            this.xRayErrorPercent = xRayErrorPercent;
        }

        @Override
        public final Builder xRayErrorPercent(Integer xRayErrorPercent) {
            this.xRayErrorPercent = xRayErrorPercent;
            return this;
        }

        public final Integer getXRayRequestCount() {
            return xRayRequestCount;
        }

        public final void setXRayRequestCount(Integer xRayRequestCount) {
            this.xRayRequestCount = xRayRequestCount;
        }

        @Override
        public final Builder xRayRequestCount(Integer xRayRequestCount) {
            this.xRayRequestCount = xRayRequestCount;
            return this;
        }

        public final Long getXRayRequestAverageLatency() {
            return xRayRequestAverageLatency;
        }

        public final void setXRayRequestAverageLatency(Long xRayRequestAverageLatency) {
            this.xRayRequestAverageLatency = xRayRequestAverageLatency;
        }

        @Override
        public final Builder xRayRequestAverageLatency(Long xRayRequestAverageLatency) {
            this.xRayRequestAverageLatency = xRayRequestAverageLatency;
            return this;
        }

        public final String getXRayNodeName() {
            return xRayNodeName;
        }

        public final void setXRayNodeName(String xRayNodeName) {
            this.xRayNodeName = xRayNodeName;
        }

        @Override
        public final Builder xRayNodeName(String xRayNodeName) {
            this.xRayNodeName = xRayNodeName;
            return this;
        }

        public final String getXRayNodeType() {
            return xRayNodeType;
        }

        public final void setXRayNodeType(String xRayNodeType) {
            this.xRayNodeType = xRayNodeType;
        }

        @Override
        public final Builder xRayNodeType(String xRayNodeType) {
            this.xRayNodeType = xRayNodeType;
            return this;
        }

        @Override
        public Observation build() {
            return new Observation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
