/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.LogPattern;
import software.amazon.awssdk.services.applicationinsights.model.LogPatternListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogPatternsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListLogPatternsResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ListLogPatternsResponse.getter(ListLogPatternsResponse::resourceGroupName)).setter(ListLogPatternsResponse.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListLogPatternsResponse.getter(ListLogPatternsResponse::accountId)).setter(ListLogPatternsResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<LogPattern>> LOG_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogPatterns").getter(ListLogPatternsResponse.getter(ListLogPatternsResponse::logPatterns)).setter(ListLogPatternsResponse.setter(Builder::logPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLogPatternsResponse.getter(ListLogPatternsResponse::nextToken)).setter(ListLogPatternsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, ACCOUNT_ID_FIELD, LOG_PATTERNS_FIELD, NEXT_TOKEN_FIELD));
    private final String resourceGroupName;
    private final String accountId;
    private final List<LogPattern> logPatterns;
    private final String nextToken;

    private ListLogPatternsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.accountId = builder.accountId;
        this.logPatterns = builder.logPatterns;
        this.nextToken = builder.nextToken;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasLogPatterns() {
        return this.logPatterns != null && !(this.logPatterns instanceof SdkAutoConstructList);
    }

    public final List<LogPattern> logPatterns() {
        return this.logPatterns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPatterns() ? this.logPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogPatternsResponse)) {
            return false;
        }
        ListLogPatternsResponse other = (ListLogPatternsResponse)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.accountId(), other.accountId()) && this.hasLogPatterns() == other.hasLogPatterns() && Objects.equals(this.logPatterns(), other.logPatterns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogPatternsResponse").add("ResourceGroupName", (Object)this.resourceGroupName()).add("AccountId", (Object)this.accountId()).add("LogPatterns", this.hasLogPatterns() ? this.logPatterns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "LogPatterns": {
                return Optional.ofNullable(clazz.cast(this.logPatterns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogPatternsResponse, T> g) {
        return obj -> g.apply((ListLogPatternsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String accountId;
        private List<LogPattern> logPatterns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogPatternsResponse model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.accountId(model.accountId);
            this.logPatterns(model.logPatterns);
            this.nextToken(model.nextToken);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<LogPattern.Builder> getLogPatterns() {
            List<LogPattern.Builder> result = LogPatternListCopier.copyToBuilder(this.logPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogPatterns(Collection<LogPattern.BuilderImpl> logPatterns) {
            this.logPatterns = LogPatternListCopier.copyFromBuilder(logPatterns);
        }

        @Override
        public final Builder logPatterns(Collection<LogPattern> logPatterns) {
            this.logPatterns = LogPatternListCopier.copy(logPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(LogPattern ... logPatterns) {
            this.logPatterns(Arrays.asList(logPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(Consumer<LogPattern.Builder> ... logPatterns) {
            this.logPatterns(Stream.of(logPatterns).map(c -> (LogPattern)((LogPattern.Builder)LogPattern.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLogPatternsResponse build() {
            return new ListLogPatternsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogPatternsResponse> {
        public Builder resourceGroupName(String var1);

        public Builder accountId(String var1);

        public Builder logPatterns(Collection<LogPattern> var1);

        public Builder logPatterns(LogPattern ... var1);

        public Builder logPatterns(Consumer<LogPattern.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

