/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackCopier;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackKey;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackValue;
import software.amazon.awssdk.services.applicationinsights.model.SeverityLevel;
import software.amazon.awssdk.services.applicationinsights.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Problem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Problem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Problem.getter(Problem::id)).setter(Problem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Problem.getter(Problem::title)).setter(Problem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Insights").getter(Problem.getter(Problem::insights)).setter(Problem.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Problem.getter(Problem::statusAsString)).setter(Problem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AFFECTED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AffectedResource").getter(Problem.getter(Problem::affectedResource)).setter(Problem.setter(Builder::affectedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedResource").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Problem.getter(Problem::startTime)).setter(Problem.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Problem.getter(Problem::endTime)).setter(Problem.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SEVERITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeverityLevel").getter(Problem.getter(Problem::severityLevelAsString)).setter(Problem.setter(Builder::severityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLevel").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(Problem.getter(Problem::resourceGroupName)).setter(Problem.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<Map<String, String>> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Feedback").getter(Problem.getter(Problem::feedbackAsStrings)).setter(Problem.setter(Builder::feedbackWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> RECURRING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecurringCount").getter(Problem.getter(Problem::recurringCount)).setter(Problem.setter(Builder::recurringCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCount").build()}).build();
    private static final SdkField<Instant> LAST_RECURRENCE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRecurrenceTime").getter(Problem.getter(Problem::lastRecurrenceTime)).setter(Problem.setter(Builder::lastRecurrenceTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecurrenceTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, INSIGHTS_FIELD, STATUS_FIELD, AFFECTED_RESOURCE_FIELD, START_TIME_FIELD, END_TIME_FIELD, SEVERITY_LEVEL_FIELD, RESOURCE_GROUP_NAME_FIELD, FEEDBACK_FIELD, RECURRING_COUNT_FIELD, LAST_RECURRENCE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final String insights;
    private final String status;
    private final String affectedResource;
    private final Instant startTime;
    private final Instant endTime;
    private final String severityLevel;
    private final String resourceGroupName;
    private final Map<String, String> feedback;
    private final Long recurringCount;
    private final Instant lastRecurrenceTime;

    private Problem(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.insights = builder.insights;
        this.status = builder.status;
        this.affectedResource = builder.affectedResource;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.severityLevel = builder.severityLevel;
        this.resourceGroupName = builder.resourceGroupName;
        this.feedback = builder.feedback;
        this.recurringCount = builder.recurringCount;
        this.lastRecurrenceTime = builder.lastRecurrenceTime;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final String insights() {
        return this.insights;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String affectedResource() {
        return this.affectedResource;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final SeverityLevel severityLevel() {
        return SeverityLevel.fromValue(this.severityLevel);
    }

    public final String severityLevelAsString() {
        return this.severityLevel;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final Map<FeedbackKey, FeedbackValue> feedback() {
        return FeedbackCopier.copyStringToEnum(this.feedback);
    }

    public final boolean hasFeedback() {
        return this.feedback != null && !(this.feedback instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> feedbackAsStrings() {
        return this.feedback;
    }

    public final Long recurringCount() {
        return this.recurringCount;
    }

    public final Instant lastRecurrenceTime() {
        return this.lastRecurrenceTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.insights());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.affectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeedback() ? this.feedbackAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecurrenceTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.insights(), other.insights()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.affectedResource(), other.affectedResource()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.severityLevelAsString(), other.severityLevelAsString()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && this.hasFeedback() == other.hasFeedback() && Objects.equals(this.feedbackAsStrings(), other.feedbackAsStrings()) && Objects.equals(this.recurringCount(), other.recurringCount()) && Objects.equals(this.lastRecurrenceTime(), other.lastRecurrenceTime());
    }

    public final String toString() {
        return ToString.builder((String)"Problem").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Insights", (Object)this.insights()).add("Status", (Object)this.statusAsString()).add("AffectedResource", (Object)this.affectedResource()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("SeverityLevel", (Object)this.severityLevelAsString()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("Feedback", this.hasFeedback() ? this.feedbackAsStrings() : null).add("RecurringCount", (Object)this.recurringCount()).add("LastRecurrenceTime", (Object)this.lastRecurrenceTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AffectedResource": {
                return Optional.ofNullable(clazz.cast(this.affectedResource()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "SeverityLevel": {
                return Optional.ofNullable(clazz.cast(this.severityLevelAsString()));
            }
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsStrings()));
            }
            case "RecurringCount": {
                return Optional.ofNullable(clazz.cast(this.recurringCount()));
            }
            case "LastRecurrenceTime": {
                return Optional.ofNullable(clazz.cast(this.lastRecurrenceTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Problem, T> g) {
        return obj -> g.apply((Problem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private String insights;
        private String status;
        private String affectedResource;
        private Instant startTime;
        private Instant endTime;
        private String severityLevel;
        private String resourceGroupName;
        private Map<String, String> feedback = DefaultSdkAutoConstructMap.getInstance();
        private Long recurringCount;
        private Instant lastRecurrenceTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            this.id(model.id);
            this.title(model.title);
            this.insights(model.insights);
            this.status(model.status);
            this.affectedResource(model.affectedResource);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.severityLevel(model.severityLevel);
            this.resourceGroupName(model.resourceGroupName);
            this.feedbackWithStrings(model.feedback);
            this.recurringCount(model.recurringCount);
            this.lastRecurrenceTime(model.lastRecurrenceTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getInsights() {
            return this.insights;
        }

        public final void setInsights(String insights) {
            this.insights = insights;
        }

        @Override
        public final Builder insights(String insights) {
            this.insights = insights;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAffectedResource() {
            return this.affectedResource;
        }

        public final void setAffectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
        }

        @Override
        public final Builder affectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSeverityLevel() {
            return this.severityLevel;
        }

        public final void setSeverityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
        }

        @Override
        public final Builder severityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
            return this;
        }

        @Override
        public final Builder severityLevel(SeverityLevel severityLevel) {
            this.severityLevel(severityLevel == null ? null : severityLevel.toString());
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final Map<String, String> getFeedback() {
            if (this.feedback instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.feedback;
        }

        public final void setFeedback(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
        }

        @Override
        public final Builder feedbackWithStrings(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
            return this;
        }

        @Override
        public final Builder feedback(Map<FeedbackKey, FeedbackValue> feedback) {
            this.feedback = FeedbackCopier.copyEnumToString(feedback);
            return this;
        }

        public final Long getRecurringCount() {
            return this.recurringCount;
        }

        public final void setRecurringCount(Long recurringCount) {
            this.recurringCount = recurringCount;
        }

        @Override
        public final Builder recurringCount(Long recurringCount) {
            this.recurringCount = recurringCount;
            return this;
        }

        public final Instant getLastRecurrenceTime() {
            return this.lastRecurrenceTime;
        }

        public final void setLastRecurrenceTime(Instant lastRecurrenceTime) {
            this.lastRecurrenceTime = lastRecurrenceTime;
        }

        @Override
        public final Builder lastRecurrenceTime(Instant lastRecurrenceTime) {
            this.lastRecurrenceTime = lastRecurrenceTime;
            return this;
        }

        public Problem build() {
            return new Problem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Problem> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder insights(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder affectedResource(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder severityLevel(String var1);

        public Builder severityLevel(SeverityLevel var1);

        public Builder resourceGroupName(String var1);

        public Builder feedbackWithStrings(Map<String, String> var1);

        public Builder feedback(Map<FeedbackKey, FeedbackValue> var1);

        public Builder recurringCount(Long var1);

        public Builder lastRecurrenceTime(Instant var1);
    }
}

