/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<UpdateComponentRequest.Builder, UpdateComponentRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(UpdateComponentRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(UpdateComponentRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> NEW_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewComponentName").getter(getter(UpdateComponentRequest::newComponentName))
            .setter(setter(Builder::newComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewComponentName").build()).build();

    private static final SdkField<List<String>> RESOURCE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceList")
            .getter(getter(UpdateComponentRequest::resourceList))
            .setter(setter(Builder::resourceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            COMPONENT_NAME_FIELD, NEW_COMPONENT_NAME_FIELD, RESOURCE_LIST_FIELD));

    private final String resourceGroupName;

    private final String componentName;

    private final String newComponentName;

    private final List<String> resourceList;

    private UpdateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.newComponentName = builder.newComponentName;
        this.resourceList = builder.resourceList;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The new name of the component.
     * </p>
     * 
     * @return The new name of the component.
     */
    public final String newComponentName() {
        return newComponentName;
    }

    /**
     * Returns true if the ResourceList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceList() {
        return resourceList != null && !(resourceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource ARNs that belong to the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of resource ARNs that belong to the component.
     */
    public final List<String> resourceList() {
        return resourceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(newComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceList() ? resourceList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentRequest)) {
            return false;
        }
        UpdateComponentRequest other = (UpdateComponentRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(componentName(), other.componentName())
                && Objects.equals(newComponentName(), other.newComponentName()) && hasResourceList() == other.hasResourceList()
                && Objects.equals(resourceList(), other.resourceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentRequest").add("ResourceGroupName", resourceGroupName())
                .add("ComponentName", componentName()).add("NewComponentName", newComponentName())
                .add("ResourceList", hasResourceList() ? resourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "NewComponentName":
            return Optional.ofNullable(clazz.cast(newComponentName()));
        case "ResourceList":
            return Optional.ofNullable(clazz.cast(resourceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentRequest, T> g) {
        return obj -> g.apply((UpdateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateComponentRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The new name of the component.
         * </p>
         * 
         * @param newComponentName
         *        The new name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newComponentName(String newComponentName);

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(Collection<String> resourceList);

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(String... resourceList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String componentName;

        private String newComponentName;

        private List<String> resourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            componentName(model.componentName);
            newComponentName(model.newComponentName);
            resourceList(model.resourceList);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final String getComponentName() {
            return componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final String getNewComponentName() {
            return newComponentName;
        }

        @Override
        public final Builder newComponentName(String newComponentName) {
            this.newComponentName = newComponentName;
            return this;
        }

        public final void setNewComponentName(String newComponentName) {
            this.newComponentName = newComponentName;
        }

        public final Collection<String> getResourceList() {
            if (resourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceList;
        }

        @Override
        public final Builder resourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceList(String... resourceList) {
            resourceList(Arrays.asList(resourceList));
            return this;
        }

        public final void setResourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentRequest build() {
            return new UpdateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
