/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProblemsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListProblemsResponse.Builder, ListProblemsResponse> {
    private static final SdkField<List<Problem>> PROBLEM_LIST_FIELD = SdkField
            .<List<Problem>> builder(MarshallingType.LIST)
            .memberName("ProblemList")
            .getter(getter(ListProblemsResponse::problemList))
            .setter(setter(Builder::problemList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Problem> builder(MarshallingType.SDK_POJO)
                                            .constructor(Problem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProblemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Problem> problemList;

    private final String nextToken;

    private ListProblemsResponse(BuilderImpl builder) {
        super(builder);
        this.problemList = builder.problemList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProblemList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProblemList() {
        return problemList != null && !(problemList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of problems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProblemList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of problems.
     */
    public final List<Problem> problemList() {
        return problemList;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProblemList() ? problemList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProblemsResponse)) {
            return false;
        }
        ListProblemsResponse other = (ListProblemsResponse) obj;
        return hasProblemList() == other.hasProblemList() && Objects.equals(problemList(), other.problemList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProblemsResponse").add("ProblemList", hasProblemList() ? problemList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProblemList":
            return Optional.ofNullable(clazz.cast(problemList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProblemsResponse, T> g) {
        return obj -> g.apply((ListProblemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProblemsResponse> {
        /**
         * <p>
         * The list of problems.
         * </p>
         * 
         * @param problemList
         *        The list of problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problemList(Collection<Problem> problemList);

        /**
         * <p>
         * The list of problems.
         * </p>
         * 
         * @param problemList
         *        The list of problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problemList(Problem... problemList);

        /**
         * <p>
         * The list of problems.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Problem>.Builder} avoiding the need to
         * create one manually via {@link List<Problem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Problem>.Builder#build()} is called immediately and its
         * result is passed to {@link #problemList(List<Problem>)}.
         * 
         * @param problemList
         *        a consumer that will call methods on {@link List<Problem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #problemList(List<Problem>)
         */
        Builder problemList(Consumer<Problem.Builder>... problemList);

        /**
         * <p>
         * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private List<Problem> problemList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProblemsResponse model) {
            super(model);
            problemList(model.problemList);
            nextToken(model.nextToken);
        }

        public final Collection<Problem.Builder> getProblemList() {
            if (problemList instanceof SdkAutoConstructList) {
                return null;
            }
            return problemList != null ? problemList.stream().map(Problem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder problemList(Collection<Problem> problemList) {
            this.problemList = ProblemListCopier.copy(problemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problemList(Problem... problemList) {
            problemList(Arrays.asList(problemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problemList(Consumer<Problem.Builder>... problemList) {
            problemList(Stream.of(problemList).map(c -> Problem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProblemList(Collection<Problem.BuilderImpl> problemList) {
            this.problemList = ProblemListCopier.copyFromBuilder(problemList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProblemsResponse build() {
            return new ListProblemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
