/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogPatternRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<CreateLogPatternRequest.Builder, CreateLogPatternRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(CreateLogPatternRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatternSetName").getter(getter(CreateLogPatternRequest::patternSetName))
            .setter(setter(Builder::patternSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatternName").getter(getter(CreateLogPatternRequest::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Pattern")
            .getter(getter(CreateLogPatternRequest::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rank")
            .getter(getter(CreateLogPatternRequest::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rank").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            PATTERN_SET_NAME_FIELD, PATTERN_NAME_FIELD, PATTERN_FIELD, RANK_FIELD));

    private final String resourceGroupName;

    private final String patternSetName;

    private final String patternName;

    private final String pattern;

    private final Integer rank;

    private CreateLogPatternRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
        this.pattern = builder.pattern;
        this.rank = builder.rank;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the log pattern set.
     * </p>
     * 
     * @return The name of the log pattern set.
     */
    public final String patternSetName() {
        return patternSetName;
    }

    /**
     * <p>
     * The name of the log pattern.
     * </p>
     * 
     * @return The name of the log pattern.
     */
    public final String patternName() {
        return patternName;
    }

    /**
     * <p>
     * The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference
     * constructions are not supported.
     * </p>
     * 
     * @return The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or
     *         backreference constructions are not supported.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are
     * sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of
     * rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will
     * be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity
     * pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a
     * <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
     * Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided
     * patterns.
     * </p>
     * 
     * @return Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns
     *         are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A
     *         pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank
     *         <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the
     *         console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A
     *         <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code>
     *         severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or
     *         greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
     */
    public final Integer rank() {
        return rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogPatternRequest)) {
            return false;
        }
        CreateLogPatternRequest other = (CreateLogPatternRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(patternSetName(), other.patternSetName()) && Objects.equals(patternName(), other.patternName())
                && Objects.equals(pattern(), other.pattern()) && Objects.equals(rank(), other.rank());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLogPatternRequest").add("ResourceGroupName", resourceGroupName())
                .add("PatternSetName", patternSetName()).add("PatternName", patternName()).add("Pattern", pattern())
                .add("Rank", rank()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "PatternSetName":
            return Optional.ofNullable(clazz.cast(patternSetName()));
        case "PatternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "Rank":
            return Optional.ofNullable(clazz.cast(rank()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogPatternRequest, T> g) {
        return obj -> g.apply((CreateLogPatternRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLogPatternRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the log pattern set.
         * </p>
         * 
         * @param patternSetName
         *        The name of the log pattern set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternSetName(String patternSetName);

        /**
         * <p>
         * The name of the log pattern.
         * </p>
         * 
         * @param patternName
         *        The name of the log pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference
         * constructions are not supported.
         * </p>
         * 
         * @param pattern
         *        The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or
         *        backreference constructions are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are
         * sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern
         * of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank
         * <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console,
         * a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity
         * pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a
         * <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are
         * reserved for AWS-provided patterns.
         * </p>
         * 
         * @param rank
         *        Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The
         *        patterns are sorted by rank, so we recommend that you set your highest priority patterns with the
         *        lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A
         *        pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log
         *        patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code>
         *        rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a
         *        <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than
         *        <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String patternSetName;

        private String patternName;

        private String pattern;

        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogPatternRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            patternSetName(model.patternSetName);
            patternName(model.patternName);
            pattern(model.pattern);
            rank(model.rank);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final String getPatternSetName() {
            return patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        public final String getPatternName() {
            return patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        public final String getPattern() {
            return pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final Integer getRank() {
            return rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogPatternRequest build() {
            return new CreateLogPatternRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
