/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(CreateApplicationRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OpsCenterEnabled").getter(getter(CreateApplicationRequest::opsCenterEnabled))
            .setter(setter(Builder::opsCenterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()).build();

    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CWEMonitorEnabled").getter(getter(CreateApplicationRequest::cweMonitorEnabled))
            .setter(setter(Builder::cweMonitorEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()).build();

    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemSNSTopicArn").getter(getter(CreateApplicationRequest::opsItemSNSTopicArn))
            .setter(setter(Builder::opsItemSNSTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, TAGS_FIELD));

    private final String resourceGroupName;

    private final Boolean opsCenterEnabled;

    private final Boolean cweMonitorEnabled;

    private final String opsItemSNSTopicArn;

    private final List<Tag> tags;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * When set to <code>true</code>, creates opsItems for any problems detected on an application.
     * </p>
     * 
     * @return When set to <code>true</code>, creates opsItems for any problems detected on an application.
     */
    public final Boolean opsCenterEnabled() {
        return opsCenterEnabled;
    }

    /**
     * <p>
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
     * <code>instance terminated</code>, <code>failed deployment</code>, and others.
     * </p>
     * 
     * @return Indicates whether Application Insights can listen to CloudWatch events for the application resources,
     *         such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
     */
    public final Boolean cweMonitorEnabled() {
        return cweMonitorEnabled;
    }

    /**
     * <p>
     * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive
     * notifications for updates to the opsItem.
     * </p>
     * 
     * @return The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
     *         receive notifications for updates to the opsItem.
     */
    public final String opsItemSNSTopicArn() {
        return opsItemSNSTopicArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
     * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
     * characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
     *         <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value
     *         is 256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(opsCenterEnabled(), other.opsCenterEnabled())
                && Objects.equals(cweMonitorEnabled(), other.cweMonitorEnabled())
                && Objects.equals(opsItemSNSTopicArn(), other.opsItemSNSTopicArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ResourceGroupName", resourceGroupName())
                .add("OpsCenterEnabled", opsCenterEnabled()).add("CWEMonitorEnabled", cweMonitorEnabled())
                .add("OpsItemSNSTopicArn", opsItemSNSTopicArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "OpsCenterEnabled":
            return Optional.ofNullable(clazz.cast(opsCenterEnabled()));
        case "CWEMonitorEnabled":
            return Optional.ofNullable(clazz.cast(cweMonitorEnabled()));
        case "OpsItemSNSTopicArn":
            return Optional.ofNullable(clazz.cast(opsItemSNSTopicArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * </p>
         * 
         * @param opsCenterEnabled
         *        When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenterEnabled(Boolean opsCenterEnabled);

        /**
         * <p>
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
         * <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * </p>
         * 
         * @param cweMonitorEnabled
         *        Indicates whether Application Insights can listen to CloudWatch events for the application resources,
         *        such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cweMonitorEnabled(Boolean cweMonitorEnabled);

        /**
         * <p>
         * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
         * receive notifications for updates to the opsItem.
         * </p>
         * 
         * @param opsItemSNSTopicArn
         *        The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you
         *        to receive notifications for updates to the opsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSNSTopicArn(String opsItemSNSTopicArn);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         *        <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag
         *        value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         *        <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag
         *        value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private Boolean opsCenterEnabled;

        private Boolean cweMonitorEnabled;

        private String opsItemSNSTopicArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            opsCenterEnabled(model.opsCenterEnabled);
            cweMonitorEnabled(model.cweMonitorEnabled);
            opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            tags(model.tags);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final Boolean getOpsCenterEnabled() {
            return opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        public final Boolean getCweMonitorEnabled() {
            return cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        public final String getOpsItemSNSTopicArn() {
            return opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
