/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogFilter {
    ERROR("ERROR"),
    WARN("WARN"),
    INFO("INFO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogFilter.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogFilter> knownValues() {
        return Stream.of(LogFilter.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

