/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the performance metrics to use for the server that is used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageMetricBasis implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageMetricBasis.Builder, UsageMetricBasis> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UsageMetricBasis::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Double> PERCENTAGE_ADJUST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("percentageAdjust").getter(getter(UsageMetricBasis::percentageAdjust))
            .setter(setter(Builder::percentageAdjust))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentageAdjust").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PERCENTAGE_ADJUST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Double percentageAdjust;

    private UsageMetricBasis(BuilderImpl builder) {
        this.name = builder.name;
        this.percentageAdjust = builder.percentageAdjust;
    }

    /**
     * <p>
     * A utilization metric that is used by the recommendations.
     * </p>
     * 
     * @return A utilization metric that is used by the recommendations.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the percentage of the specified utilization metric that is used by the recommendations.
     * </p>
     * 
     * @return Specifies the percentage of the specified utilization metric that is used by the recommendations.
     */
    public final Double percentageAdjust() {
        return percentageAdjust;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(percentageAdjust());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageMetricBasis)) {
            return false;
        }
        UsageMetricBasis other = (UsageMetricBasis) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(percentageAdjust(), other.percentageAdjust());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageMetricBasis").add("Name", name()).add("PercentageAdjust", percentageAdjust()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "percentageAdjust":
            return Optional.ofNullable(clazz.cast(percentageAdjust()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("percentageAdjust", PERCENTAGE_ADJUST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageMetricBasis, T> g) {
        return obj -> g.apply((UsageMetricBasis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageMetricBasis> {
        /**
         * <p>
         * A utilization metric that is used by the recommendations.
         * </p>
         * 
         * @param name
         *        A utilization metric that is used by the recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the percentage of the specified utilization metric that is used by the recommendations.
         * </p>
         * 
         * @param percentageAdjust
         *        Specifies the percentage of the specified utilization metric that is used by the recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageAdjust(Double percentageAdjust);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Double percentageAdjust;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageMetricBasis model) {
            name(model.name);
            percentageAdjust(model.percentageAdjust);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Double getPercentageAdjust() {
            return percentageAdjust;
        }

        public final void setPercentageAdjust(Double percentageAdjust) {
            this.percentageAdjust = percentageAdjust;
        }

        @Override
        public final Builder percentageAdjust(Double percentageAdjust) {
            this.percentageAdjust = percentageAdjust;
            return this;
        }

        @Override
        public UsageMetricBasis build() {
            return new UsageMetricBasis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
