/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServerNeighborsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<ListServerNeighborsResponse.Builder, ListServerNeighborsResponse> {
    private static final SdkField<List<NeighborConnectionDetail>> NEIGHBORS_FIELD = SdkField
            .<List<NeighborConnectionDetail>> builder(MarshallingType.LIST)
            .memberName("neighbors")
            .getter(getter(ListServerNeighborsResponse::neighbors))
            .setter(setter(Builder::neighbors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neighbors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NeighborConnectionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(NeighborConnectionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServerNeighborsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> KNOWN_DEPENDENCY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("knownDependencyCount").getter(getter(ListServerNeighborsResponse::knownDependencyCount))
            .setter(setter(Builder::knownDependencyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knownDependencyCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEIGHBORS_FIELD,
            NEXT_TOKEN_FIELD, KNOWN_DEPENDENCY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<NeighborConnectionDetail> neighbors;

    private final String nextToken;

    private final Long knownDependencyCount;

    private ListServerNeighborsResponse(BuilderImpl builder) {
        super(builder);
        this.neighbors = builder.neighbors;
        this.nextToken = builder.nextToken;
        this.knownDependencyCount = builder.knownDependencyCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Neighbors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNeighbors() {
        return neighbors != null && !(neighbors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of distinct servers that are one hop away from the given server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNeighbors} method.
     * </p>
     * 
     * @return List of distinct servers that are one hop away from the given server.
     */
    public final List<NeighborConnectionDetail> neighbors() {
        return neighbors;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if you specified 100 IDs for
     * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this token.
     * Use this token in the next query to retrieve the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if you specified 100 IDs for
     *         <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     *         <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with
     *         this token. Use this token in the next query to retrieve the next set of 10.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Count of distinct servers that are one hop away from the given server.
     * </p>
     * 
     * @return Count of distinct servers that are one hop away from the given server.
     */
    public final Long knownDependencyCount() {
        return knownDependencyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNeighbors() ? neighbors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(knownDependencyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsResponse)) {
            return false;
        }
        ListServerNeighborsResponse other = (ListServerNeighborsResponse) obj;
        return hasNeighbors() == other.hasNeighbors() && Objects.equals(neighbors(), other.neighbors())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(knownDependencyCount(), other.knownDependencyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServerNeighborsResponse").add("Neighbors", hasNeighbors() ? neighbors() : null)
                .add("NextToken", nextToken()).add("KnownDependencyCount", knownDependencyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "neighbors":
            return Optional.ofNullable(clazz.cast(neighbors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "knownDependencyCount":
            return Optional.ofNullable(clazz.cast(knownDependencyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("neighbors", NEIGHBORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("knownDependencyCount", KNOWN_DEPENDENCY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServerNeighborsResponse, T> g) {
        return obj -> g.apply((ListServerNeighborsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServerNeighborsResponse> {
        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param neighbors
         *        List of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighbors(Collection<NeighborConnectionDetail> neighbors);

        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param neighbors
         *        List of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighbors(NeighborConnectionDetail... neighbors);

        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail.Builder#build()}
         * is called immediately and its result is passed to {@link #neighbors(List<NeighborConnectionDetail>)}.
         * 
         * @param neighbors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #neighbors(java.util.Collection<NeighborConnectionDetail>)
         */
        Builder neighbors(Consumer<NeighborConnectionDetail.Builder>... neighbors);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if you specified 100 IDs for
         * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this
         * token. Use this token in the next query to retrieve the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if you specified 100 IDs for
         *        <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         *        <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with
         *        this token. Use this token in the next query to retrieve the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Count of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param knownDependencyCount
         *        Count of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownDependencyCount(Long knownDependencyCount);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<NeighborConnectionDetail> neighbors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long knownDependencyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsResponse model) {
            super(model);
            neighbors(model.neighbors);
            nextToken(model.nextToken);
            knownDependencyCount(model.knownDependencyCount);
        }

        public final List<NeighborConnectionDetail.Builder> getNeighbors() {
            List<NeighborConnectionDetail.Builder> result = NeighborDetailsListCopier.copyToBuilder(this.neighbors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNeighbors(Collection<NeighborConnectionDetail.BuilderImpl> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copyFromBuilder(neighbors);
        }

        @Override
        public final Builder neighbors(Collection<NeighborConnectionDetail> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copy(neighbors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighbors(NeighborConnectionDetail... neighbors) {
            neighbors(Arrays.asList(neighbors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighbors(Consumer<NeighborConnectionDetail.Builder>... neighbors) {
            neighbors(Stream.of(neighbors).map(c -> NeighborConnectionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getKnownDependencyCount() {
            return knownDependencyCount;
        }

        public final void setKnownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
        }

        @Override
        public final Builder knownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
            return this;
        }

        @Override
        public ListServerNeighborsResponse build() {
            return new ListServerNeighborsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
