/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ExcludedInstanceTypesCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ReservedInstanceOptions;
import software.amazon.awssdk.services.applicationdiscovery.model.Tenancy;
import software.amazon.awssdk.services.applicationdiscovery.model.UsageMetricBasis;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2RecommendationsExportPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2RecommendationsExportPreferences> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::enabled)).setter(Ec2RecommendationsExportPreferences.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<UsageMetricBasis> CPU_PERFORMANCE_METRIC_BASIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cpuPerformanceMetricBasis").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::cpuPerformanceMetricBasis)).setter(Ec2RecommendationsExportPreferences.setter(Builder::cpuPerformanceMetricBasis)).constructor(UsageMetricBasis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuPerformanceMetricBasis").build()}).build();
    private static final SdkField<UsageMetricBasis> RAM_PERFORMANCE_METRIC_BASIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ramPerformanceMetricBasis").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::ramPerformanceMetricBasis)).setter(Ec2RecommendationsExportPreferences.setter(Builder::ramPerformanceMetricBasis)).constructor(UsageMetricBasis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramPerformanceMetricBasis").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenancy").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::tenancyAsString)).setter(Ec2RecommendationsExportPreferences.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenancy").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludedInstanceTypes").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::excludedInstanceTypes)).setter(Ec2RecommendationsExportPreferences.setter(Builder::excludedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredRegion").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::preferredRegion)).setter(Ec2RecommendationsExportPreferences.setter(Builder::preferredRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredRegion").build()}).build();
    private static final SdkField<ReservedInstanceOptions> RESERVED_INSTANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reservedInstanceOptions").getter(Ec2RecommendationsExportPreferences.getter(Ec2RecommendationsExportPreferences::reservedInstanceOptions)).setter(Ec2RecommendationsExportPreferences.setter(Builder::reservedInstanceOptions)).constructor(ReservedInstanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstanceOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, CPU_PERFORMANCE_METRIC_BASIS_FIELD, RAM_PERFORMANCE_METRIC_BASIS_FIELD, TENANCY_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, PREFERRED_REGION_FIELD, RESERVED_INSTANCE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2RecommendationsExportPreferences.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final UsageMetricBasis cpuPerformanceMetricBasis;
    private final UsageMetricBasis ramPerformanceMetricBasis;
    private final String tenancy;
    private final List<String> excludedInstanceTypes;
    private final String preferredRegion;
    private final ReservedInstanceOptions reservedInstanceOptions;

    private Ec2RecommendationsExportPreferences(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.cpuPerformanceMetricBasis = builder.cpuPerformanceMetricBasis;
        this.ramPerformanceMetricBasis = builder.ramPerformanceMetricBasis;
        this.tenancy = builder.tenancy;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.preferredRegion = builder.preferredRegion;
        this.reservedInstanceOptions = builder.reservedInstanceOptions;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final UsageMetricBasis cpuPerformanceMetricBasis() {
        return this.cpuPerformanceMetricBasis;
    }

    public final UsageMetricBasis ramPerformanceMetricBasis() {
        return this.ramPerformanceMetricBasis;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final boolean hasExcludedInstanceTypes() {
        return this.excludedInstanceTypes != null && !(this.excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public final String preferredRegion() {
        return this.preferredRegion;
    }

    public final ReservedInstanceOptions reservedInstanceOptions() {
        return this.reservedInstanceOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuPerformanceMetricBasis());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramPerformanceMetricBasis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2RecommendationsExportPreferences)) {
            return false;
        }
        Ec2RecommendationsExportPreferences other = (Ec2RecommendationsExportPreferences)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.cpuPerformanceMetricBasis(), other.cpuPerformanceMetricBasis()) && Objects.equals(this.ramPerformanceMetricBasis(), other.ramPerformanceMetricBasis()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && this.hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes() && Objects.equals(this.excludedInstanceTypes(), other.excludedInstanceTypes()) && Objects.equals(this.preferredRegion(), other.preferredRegion()) && Objects.equals(this.reservedInstanceOptions(), other.reservedInstanceOptions());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2RecommendationsExportPreferences").add("Enabled", (Object)this.enabled()).add("CpuPerformanceMetricBasis", (Object)this.cpuPerformanceMetricBasis()).add("RamPerformanceMetricBasis", (Object)this.ramPerformanceMetricBasis()).add("Tenancy", (Object)this.tenancyAsString()).add("ExcludedInstanceTypes", this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null).add("PreferredRegion", (Object)this.preferredRegion()).add("ReservedInstanceOptions", (Object)this.reservedInstanceOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "cpuPerformanceMetricBasis": {
                return Optional.ofNullable(clazz.cast(this.cpuPerformanceMetricBasis()));
            }
            case "ramPerformanceMetricBasis": {
                return Optional.ofNullable(clazz.cast(this.ramPerformanceMetricBasis()));
            }
            case "tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "excludedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.excludedInstanceTypes()));
            }
            case "preferredRegion": {
                return Optional.ofNullable(clazz.cast(this.preferredRegion()));
            }
            case "reservedInstanceOptions": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("cpuPerformanceMetricBasis", CPU_PERFORMANCE_METRIC_BASIS_FIELD);
        map.put("ramPerformanceMetricBasis", RAM_PERFORMANCE_METRIC_BASIS_FIELD);
        map.put("tenancy", TENANCY_FIELD);
        map.put("excludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        map.put("preferredRegion", PREFERRED_REGION_FIELD);
        map.put("reservedInstanceOptions", RESERVED_INSTANCE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2RecommendationsExportPreferences, T> g) {
        return obj -> g.apply((Ec2RecommendationsExportPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private UsageMetricBasis cpuPerformanceMetricBasis;
        private UsageMetricBasis ramPerformanceMetricBasis;
        private String tenancy;
        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String preferredRegion;
        private ReservedInstanceOptions reservedInstanceOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2RecommendationsExportPreferences model) {
            this.enabled(model.enabled);
            this.cpuPerformanceMetricBasis(model.cpuPerformanceMetricBasis);
            this.ramPerformanceMetricBasis(model.ramPerformanceMetricBasis);
            this.tenancy(model.tenancy);
            this.excludedInstanceTypes(model.excludedInstanceTypes);
            this.preferredRegion(model.preferredRegion);
            this.reservedInstanceOptions(model.reservedInstanceOptions);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final UsageMetricBasis.Builder getCpuPerformanceMetricBasis() {
            return this.cpuPerformanceMetricBasis != null ? this.cpuPerformanceMetricBasis.toBuilder() : null;
        }

        public final void setCpuPerformanceMetricBasis(UsageMetricBasis.BuilderImpl cpuPerformanceMetricBasis) {
            this.cpuPerformanceMetricBasis = cpuPerformanceMetricBasis != null ? cpuPerformanceMetricBasis.build() : null;
        }

        @Override
        public final Builder cpuPerformanceMetricBasis(UsageMetricBasis cpuPerformanceMetricBasis) {
            this.cpuPerformanceMetricBasis = cpuPerformanceMetricBasis;
            return this;
        }

        public final UsageMetricBasis.Builder getRamPerformanceMetricBasis() {
            return this.ramPerformanceMetricBasis != null ? this.ramPerformanceMetricBasis.toBuilder() : null;
        }

        public final void setRamPerformanceMetricBasis(UsageMetricBasis.BuilderImpl ramPerformanceMetricBasis) {
            this.ramPerformanceMetricBasis = ramPerformanceMetricBasis != null ? ramPerformanceMetricBasis.build() : null;
        }

        @Override
        public final Builder ramPerformanceMetricBasis(UsageMetricBasis ramPerformanceMetricBasis) {
            this.ramPerformanceMetricBasis = ramPerformanceMetricBasis;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (this.excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypesCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypesCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String ... excludedInstanceTypes) {
            this.excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final String getPreferredRegion() {
            return this.preferredRegion;
        }

        public final void setPreferredRegion(String preferredRegion) {
            this.preferredRegion = preferredRegion;
        }

        @Override
        public final Builder preferredRegion(String preferredRegion) {
            this.preferredRegion = preferredRegion;
            return this;
        }

        public final ReservedInstanceOptions.Builder getReservedInstanceOptions() {
            return this.reservedInstanceOptions != null ? this.reservedInstanceOptions.toBuilder() : null;
        }

        public final void setReservedInstanceOptions(ReservedInstanceOptions.BuilderImpl reservedInstanceOptions) {
            this.reservedInstanceOptions = reservedInstanceOptions != null ? reservedInstanceOptions.build() : null;
        }

        @Override
        public final Builder reservedInstanceOptions(ReservedInstanceOptions reservedInstanceOptions) {
            this.reservedInstanceOptions = reservedInstanceOptions;
            return this;
        }

        public Ec2RecommendationsExportPreferences build() {
            return new Ec2RecommendationsExportPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2RecommendationsExportPreferences> {
        public Builder enabled(Boolean var1);

        public Builder cpuPerformanceMetricBasis(UsageMetricBasis var1);

        default public Builder cpuPerformanceMetricBasis(Consumer<UsageMetricBasis.Builder> cpuPerformanceMetricBasis) {
            return this.cpuPerformanceMetricBasis((UsageMetricBasis)((UsageMetricBasis.Builder)UsageMetricBasis.builder().applyMutation(cpuPerformanceMetricBasis)).build());
        }

        public Builder ramPerformanceMetricBasis(UsageMetricBasis var1);

        default public Builder ramPerformanceMetricBasis(Consumer<UsageMetricBasis.Builder> ramPerformanceMetricBasis) {
            return this.ramPerformanceMetricBasis((UsageMetricBasis)((UsageMetricBasis.Builder)UsageMetricBasis.builder().applyMutation(ramPerformanceMetricBasis)).build());
        }

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder excludedInstanceTypes(Collection<String> var1);

        public Builder excludedInstanceTypes(String ... var1);

        public Builder preferredRegion(String var1);

        public Builder reservedInstanceOptions(ReservedInstanceOptions var1);

        default public Builder reservedInstanceOptions(Consumer<ReservedInstanceOptions.Builder> reservedInstanceOptions) {
            return this.reservedInstanceOptions((ReservedInstanceOptions)((ReservedInstanceOptions.Builder)ReservedInstanceOptions.builder().applyMutation(reservedInstanceOptions)).build());
        }
    }
}

