/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;

public class DescribeImportTasksIterable
implements SdkIterable<DescribeImportTasksResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeImportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImportTasksIterable(ApplicationDiscoveryClient client, DescribeImportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImportTasksResponseFetcher();
    }

    public Iterator<DescribeImportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeImportTasksIterable resume(DescribeImportTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImportTasksIterable(this.client, (DescribeImportTasksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImportTasksIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeImportTasksResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeImportTasksResponseFetcher
    implements SyncPageFetcher<DescribeImportTasksResponse> {
        private DescribeImportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImportTasksResponse nextPage(DescribeImportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportTasksIterable.this.client.describeImportTasks(DescribeImportTasksIterable.this.firstRequest);
            }
            return DescribeImportTasksIterable.this.client.describeImportTasks((DescribeImportTasksRequest)((Object)DescribeImportTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

