/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail;
import software.amazon.awssdk.services.applicationdiscovery.model.NeighborDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServerNeighborsResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, ListServerNeighborsResponse> {
    private static final SdkField<List<NeighborConnectionDetail>> NEIGHBORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("neighbors").getter(ListServerNeighborsResponse.getter(ListServerNeighborsResponse::neighbors)).setter(ListServerNeighborsResponse.setter(Builder::neighbors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neighbors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NeighborConnectionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServerNeighborsResponse.getter(ListServerNeighborsResponse::nextToken)).setter(ListServerNeighborsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> KNOWN_DEPENDENCY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("knownDependencyCount").getter(ListServerNeighborsResponse.getter(ListServerNeighborsResponse::knownDependencyCount)).setter(ListServerNeighborsResponse.setter(Builder::knownDependencyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knownDependencyCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEIGHBORS_FIELD, NEXT_TOKEN_FIELD, KNOWN_DEPENDENCY_COUNT_FIELD));
    private final List<NeighborConnectionDetail> neighbors;
    private final String nextToken;
    private final Long knownDependencyCount;

    private ListServerNeighborsResponse(BuilderImpl builder) {
        super(builder);
        this.neighbors = builder.neighbors;
        this.nextToken = builder.nextToken;
        this.knownDependencyCount = builder.knownDependencyCount;
    }

    public final boolean hasNeighbors() {
        return this.neighbors != null && !(this.neighbors instanceof SdkAutoConstructList);
    }

    public final List<NeighborConnectionDetail> neighbors() {
        return this.neighbors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long knownDependencyCount() {
        return this.knownDependencyCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNeighbors() ? this.neighbors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.knownDependencyCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsResponse)) {
            return false;
        }
        ListServerNeighborsResponse other = (ListServerNeighborsResponse)((Object)obj);
        return this.hasNeighbors() == other.hasNeighbors() && Objects.equals(this.neighbors(), other.neighbors()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.knownDependencyCount(), other.knownDependencyCount());
    }

    public final String toString() {
        return ToString.builder((String)"ListServerNeighborsResponse").add("Neighbors", this.hasNeighbors() ? this.neighbors() : null).add("NextToken", (Object)this.nextToken()).add("KnownDependencyCount", (Object)this.knownDependencyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "neighbors": {
                return Optional.ofNullable(clazz.cast(this.neighbors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "knownDependencyCount": {
                return Optional.ofNullable(clazz.cast(this.knownDependencyCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServerNeighborsResponse, T> g) {
        return obj -> g.apply((ListServerNeighborsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<NeighborConnectionDetail> neighbors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long knownDependencyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsResponse model) {
            super(model);
            this.neighbors(model.neighbors);
            this.nextToken(model.nextToken);
            this.knownDependencyCount(model.knownDependencyCount);
        }

        public final List<NeighborConnectionDetail.Builder> getNeighbors() {
            List<NeighborConnectionDetail.Builder> result = NeighborDetailsListCopier.copyToBuilder(this.neighbors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNeighbors(Collection<NeighborConnectionDetail.BuilderImpl> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copyFromBuilder(neighbors);
        }

        @Override
        @Transient
        public final Builder neighbors(Collection<NeighborConnectionDetail> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copy(neighbors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder neighbors(NeighborConnectionDetail ... neighbors) {
            this.neighbors(Arrays.asList(neighbors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder neighbors(Consumer<NeighborConnectionDetail.Builder> ... neighbors) {
            this.neighbors(Stream.of(neighbors).map(c -> (NeighborConnectionDetail)((NeighborConnectionDetail.Builder)NeighborConnectionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getKnownDependencyCount() {
            return this.knownDependencyCount;
        }

        public final void setKnownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
        }

        @Override
        @Transient
        public final Builder knownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
            return this;
        }

        @Override
        public ListServerNeighborsResponse build() {
            return new ListServerNeighborsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServerNeighborsResponse> {
        public Builder neighbors(Collection<NeighborConnectionDetail> var1);

        public Builder neighbors(NeighborConnectionDetail ... var1);

        public Builder neighbors(Consumer<NeighborConnectionDetail.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder knownDependencyCount(Long var1);
    }
}

