/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContinuousExportsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<DescribeContinuousExportsRequest.Builder, DescribeContinuousExportsRequest> {
    private static final SdkField<List<String>> EXPORT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContinuousExportsRequest::exportIds))
            .setter(setter(Builder::exportIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeContinuousExportsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeContinuousExportsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_IDS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> exportIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeContinuousExportsRequest(BuilderImpl builder) {
        super(builder);
        this.exportIds = builder.exportIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ExportIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExportIds() {
        return exportIds != null && !(exportIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique IDs assigned to the exports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The unique IDs assigned to the exports.
     */
    public List<String> exportIds() {
        return exportIds;
    }

    /**
     * <p>
     * A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.
     * </p>
     * 
     * @return A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token from the previous call to <code>DescribeExportTasks</code>.
     * </p>
     * 
     * @return The token from the previous call to <code>DescribeExportTasks</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContinuousExportsRequest)) {
            return false;
        }
        DescribeContinuousExportsRequest other = (DescribeContinuousExportsRequest) obj;
        return Objects.equals(exportIds(), other.exportIds()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeContinuousExportsRequest").add("ExportIds", exportIds()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportIds":
            return Optional.ofNullable(clazz.cast(exportIds()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContinuousExportsRequest, T> g) {
        return obj -> g.apply((DescribeContinuousExportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeContinuousExportsRequest> {
        /**
         * <p>
         * The unique IDs assigned to the exports.
         * </p>
         * 
         * @param exportIds
         *        The unique IDs assigned to the exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIds(Collection<String> exportIds);

        /**
         * <p>
         * The unique IDs assigned to the exports.
         * </p>
         * 
         * @param exportIds
         *        The unique IDs assigned to the exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIds(String... exportIds);

        /**
         * <p>
         * A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.
         * </p>
         * 
         * @param maxResults
         *        A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token from the previous call to <code>DescribeExportTasks</code>.
         * </p>
         * 
         * @param nextToken
         *        The token from the previous call to <code>DescribeExportTasks</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> exportIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContinuousExportsRequest model) {
            super(model);
            exportIds(model.exportIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getExportIds() {
            return exportIds;
        }

        @Override
        public final Builder exportIds(Collection<String> exportIds) {
            this.exportIds = ContinuousExportIdsCopier.copy(exportIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportIds(String... exportIds) {
            exportIds(Arrays.asList(exportIds));
            return this;
        }

        public final void setExportIds(Collection<String> exportIds) {
            this.exportIds = ContinuousExportIdsCopier.copy(exportIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeContinuousExportsRequest build() {
            return new DescribeContinuousExportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
