/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportTaskRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<StartImportTaskRequest.Builder, StartImportTaskRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> IMPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportTaskRequest::importUrl)).setter(setter(Builder::importUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            NAME_FIELD, IMPORT_URL_FIELD));

    private final String clientRequestToken;

    private final String name;

    private final String importUrl;

    private StartImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.importUrl = builder.importUrl;
    }

    /**
     * <p>
     * Optional. A unique token that you can provide to prevent the same import request from occurring more than once.
     * If you don't provide a token, a token is automatically generated.
     * </p>
     * <p>
     * Sending more than one <code>StartImportTask</code> request with the same client request token will return
     * information about the original import task with that client request token.
     * </p>
     * 
     * @return Optional. A unique token that you can provide to prevent the same import request from occurring more than
     *         once. If you don't provide a token, a token is automatically generated.</p>
     *         <p>
     *         Sending more than one <code>StartImportTask</code> request with the same client request token will return
     *         information about the original import task with that client request token.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * A descriptive name for this request. You can use this name to filter future requests related to this import task,
     * such as identifying applications and servers that were included in this import task. We recommend that you use a
     * meaningful name for each import task.
     * </p>
     * 
     * @return A descriptive name for this request. You can use this name to filter future requests related to this
     *         import task, such as identifying applications and servers that were included in this import task. We
     *         recommend that you use a meaningful name for each import task.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The URL for your import file that you've uploaded to Amazon S3.
     * </p>
     * <note>
     * <p>
     * If you're using the AWS CLI, this URL is structured as follows: <code>s3://BucketName/ImportFileName.CSV</code>
     * </p>
     * </note>
     * 
     * @return The URL for your import file that you've uploaded to Amazon S3.</p> <note>
     *         <p>
     *         If you're using the AWS CLI, this URL is structured as follows:
     *         <code>s3://BucketName/ImportFileName.CSV</code>
     *         </p>
     */
    public String importUrl() {
        return importUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(importUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportTaskRequest)) {
            return false;
        }
        StartImportTaskRequest other = (StartImportTaskRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(name(), other.name())
                && Objects.equals(importUrl(), other.importUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartImportTaskRequest").add("ClientRequestToken", clientRequestToken()).add("Name", name())
                .add("ImportUrl", importUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "importUrl":
            return Optional.ofNullable(clazz.cast(importUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportTaskRequest, T> g) {
        return obj -> g.apply((StartImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartImportTaskRequest> {
        /**
         * <p>
         * Optional. A unique token that you can provide to prevent the same import request from occurring more than
         * once. If you don't provide a token, a token is automatically generated.
         * </p>
         * <p>
         * Sending more than one <code>StartImportTask</code> request with the same client request token will return
         * information about the original import task with that client request token.
         * </p>
         * 
         * @param clientRequestToken
         *        Optional. A unique token that you can provide to prevent the same import request from occurring more
         *        than once. If you don't provide a token, a token is automatically generated.</p>
         *        <p>
         *        Sending more than one <code>StartImportTask</code> request with the same client request token will
         *        return information about the original import task with that client request token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A descriptive name for this request. You can use this name to filter future requests related to this import
         * task, such as identifying applications and servers that were included in this import task. We recommend that
         * you use a meaningful name for each import task.
         * </p>
         * 
         * @param name
         *        A descriptive name for this request. You can use this name to filter future requests related to this
         *        import task, such as identifying applications and servers that were included in this import task. We
         *        recommend that you use a meaningful name for each import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URL for your import file that you've uploaded to Amazon S3.
         * </p>
         * <note>
         * <p>
         * If you're using the AWS CLI, this URL is structured as follows:
         * <code>s3://BucketName/ImportFileName.CSV</code>
         * </p>
         * </note>
         * 
         * @param importUrl
         *        The URL for your import file that you've uploaded to Amazon S3.</p> <note>
         *        <p>
         *        If you're using the AWS CLI, this URL is structured as follows:
         *        <code>s3://BucketName/ImportFileName.CSV</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importUrl(String importUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String name;

        private String importUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportTaskRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            name(model.name);
            importUrl(model.importUrl);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImportUrl() {
            return importUrl;
        }

        @Override
        public final Builder importUrl(String importUrl) {
            this.importUrl = importUrl;
            return this;
        }

        public final void setImportUrl(String importUrl) {
            this.importUrl = importUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportTaskRequest build() {
            return new StartImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
