/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<ListConfigurationsRequest.Builder, ListConfigurationsRequest> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigurationsRequest::configurationTypeAsString)).setter(setter(Builder::configurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationType").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(ListConfigurationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListConfigurationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigurationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<OrderByElement>> ORDER_BY_FIELD = SdkField
            .<List<OrderByElement>> builder(MarshallingType.LIST)
            .getter(getter(ListConfigurationsRequest::orderBy))
            .setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderByElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderByElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_FIELD));

    private final String configurationType;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<OrderByElement> orderBy;

    private ListConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationType = builder.configurationType;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * A valid configuration identified by Application Discovery Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return A valid configuration identified by Application Discovery Service.
     * @see ConfigurationItemType
     */
    public ConfigurationItemType configurationType() {
        return ConfigurationItemType.fromValue(configurationType);
    }

    /**
     * <p>
     * A valid configuration identified by Application Discovery Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configurationType}
     * will return {@link ConfigurationItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configurationTypeAsString}.
     * </p>
     * 
     * @return A valid configuration identified by Application Discovery Service.
     * @see ConfigurationItemType
     */
    public String configurationTypeAsString() {
        return configurationType;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
     * </p>
     * <p>
     * <code>{"key": "serverType", "value": "webServer"}</code>
     * </p>
     * <p>
     * For a complete list of filter options and guidance about using them with this action, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
     * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
     *         example: </p>
     *         <p>
     *         <code>{"key": "serverType", "value": "webServer"}</code>
     *         </p>
     *         <p>
     *         For a complete list of filter options and guidance about using them with this action, see <a href=
     *         "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
     *         >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The total number of items to return. The maximum value is 100.
     * </p>
     * 
     * @return The total number of items to return. The maximum value is 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100
     * items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
     * along with a token. Use that token in this query to get the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned
     *         100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10
     *         results along with a token. Use that token in this query to get the next set of 10.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the OrderBy property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOrderBy() {
        return orderBy != null && !(orderBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output
     * characteristics for each filter, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
     * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderBy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Certain filter criteria return output that can be sorted in ascending or descending order. For a list of
     *         output characteristics for each filter, see <a href=
     *         "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
     *         >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     */
    public List<OrderByElement> orderBy() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsRequest)) {
            return false;
        }
        ListConfigurationsRequest other = (ListConfigurationsRequest) obj;
        return Objects.equals(configurationTypeAsString(), other.configurationTypeAsString())
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(orderBy(), other.orderBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListConfigurationsRequest").add("ConfigurationType", configurationTypeAsString())
                .add("Filters", filters()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OrderBy", orderBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationType":
            return Optional.ofNullable(clazz.cast(configurationTypeAsString()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationsRequest, T> g) {
        return obj -> g.apply((ListConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationsRequest> {
        /**
         * <p>
         * A valid configuration identified by Application Discovery Service.
         * </p>
         * 
         * @param configurationType
         *        A valid configuration identified by Application Discovery Service.
         * @see ConfigurationItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemType
         */
        Builder configurationType(String configurationType);

        /**
         * <p>
         * A valid configuration identified by Application Discovery Service.
         * </p>
         * 
         * @param configurationType
         *        A valid configuration identified by Application Discovery Service.
         * @see ConfigurationItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemType
         */
        Builder configurationType(ConfigurationItemType configurationType);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * <p>
         * For a complete list of filter options and guidance about using them with this action, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * 
         * @param filters
         *        You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
         *        example: </p>
         *        <p>
         *        <code>{"key": "serverType", "value": "webServer"}</code>
         *        </p>
         *        <p>
         *        For a complete list of filter options and guidance about using them with this action, see <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         *        >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * <p>
         * For a complete list of filter options and guidance about using them with this action, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * 
         * @param filters
         *        You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For
         *        example: </p>
         *        <p>
         *        <code>{"key": "serverType", "value": "webServer"}</code>
         *        </p>
         *        <p>
         *        For a complete list of filter options and guidance about using them with this action, see <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         *        >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example:
         * </p>
         * <p>
         * <code>{"key": "serverType", "value": "webServer"}</code>
         * </p>
         * <p>
         * For a complete list of filter options and guidance about using them with this action, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The total number of items to return. The maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100
         * items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
         * along with a token. Use that token in this query to get the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if a previous call to ListConfigurations
         *        returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received
         *        a set of 10 results along with a token. Use that token in this query to get the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of
         * output characteristics for each filter, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * 
         * @param orderBy
         *        Certain filter criteria return output that can be sorted in ascending or descending order. For a list
         *        of output characteristics for each filter, see <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         *        >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(Collection<OrderByElement> orderBy);

        /**
         * <p>
         * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of
         * output characteristics for each filter, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * 
         * @param orderBy
         *        Certain filter criteria return output that can be sorted in ascending or descending order. For a list
         *        of output characteristics for each filter, see <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         *        >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(OrderByElement... orderBy);

        /**
         * <p>
         * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of
         * output characteristics for each filter, see <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations"
         * >Using the ListConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrderByElement>.Builder} avoiding the need
         * to create one manually via {@link List<OrderByElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrderByElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #orderBy(List<OrderByElement>)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on {@link List<OrderByElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(List<OrderByElement>)
         */
        Builder orderBy(Consumer<OrderByElement.Builder>... orderBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private String configurationType;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<OrderByElement> orderBy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsRequest model) {
            super(model);
            configurationType(model.configurationType);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            orderBy(model.orderBy);
        }

        public final String getConfigurationTypeAsString() {
            return configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationItemType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OrderByElement.Builder> getOrderBy() {
            return orderBy != null ? orderBy.stream().map(OrderByElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderBy(Collection<OrderByElement> orderBy) {
            this.orderBy = OrderByListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(OrderByElement... orderBy) {
            orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<OrderByElement.Builder>... orderBy) {
            orderBy(Stream.of(orderBy).map(c -> OrderByElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderBy(Collection<OrderByElement.BuilderImpl> orderBy) {
            this.orderBy = OrderByListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationsRequest build() {
            return new ListConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
