/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartExportTaskRequestModelMarshaller {
    private static final MarshallingInfo<List> EXPORTDATAFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exportDataFormat").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filters").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final StartExportTaskRequestModelMarshaller INSTANCE = new StartExportTaskRequestModelMarshaller();

    private StartExportTaskRequestModelMarshaller() {
    }

    public static StartExportTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartExportTaskRequest startExportTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startExportTaskRequest), (String)"startExportTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(startExportTaskRequest.exportDataFormatAsStrings(), EXPORTDATAFORMAT_BINDING);
            protocolMarshaller.marshall(startExportTaskRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)startExportTaskRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)startExportTaskRequest.endTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

