/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportFilterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("values").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("condition").isBinary(false).build();
    private static final ExportFilterMarshaller INSTANCE = new ExportFilterMarshaller();

    private ExportFilterMarshaller() {
    }

    public static ExportFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportFilter exportFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportFilter, (String)"exportFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportFilter.name(), NAME_BINDING);
            protocolMarshaller.marshall(exportFilter.values(), VALUES_BINDING);
            protocolMarshaller.marshall((Object)exportFilter.condition(), CONDITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

