/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerConnectorInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CustomerConnectorInfoMarshaller {
    private static final MarshallingInfo<Integer> ACTIVECONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> HEALTHYCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthyConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> BLACKLISTEDCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blackListedConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> SHUTDOWNCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shutdownConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> UNHEALTHYCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unhealthyConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalConnectors").isBinary(false).build();
    private static final MarshallingInfo<Integer> UNKNOWNCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unknownConnectors").isBinary(false).build();
    private static final CustomerConnectorInfoMarshaller INSTANCE = new CustomerConnectorInfoMarshaller();

    private CustomerConnectorInfoMarshaller() {
    }

    public static CustomerConnectorInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CustomerConnectorInfo customerConnectorInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)customerConnectorInfo, (String)"customerConnectorInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)customerConnectorInfo.activeConnectors(), ACTIVECONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.healthyConnectors(), HEALTHYCONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.blackListedConnectors(), BLACKLISTEDCONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.shutdownConnectors(), SHUTDOWNCONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.unhealthyConnectors(), UNHEALTHYCONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.totalConnectors(), TOTALCONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)customerConnectorInfo.unknownConnectors(), UNKNOWNCONNECTORS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

