/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentIdsCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopDataCollectionByAgentIdsRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, StopDataCollectionByAgentIdsRequest> {
    private final List<String> agentIds;

    private StopDataCollectionByAgentIdsRequest(BuilderImpl builder) {
        super(builder);
        this.agentIds = builder.agentIds;
    }

    public List<String> agentIds() {
        return this.agentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDataCollectionByAgentIdsRequest)) {
            return false;
        }
        StopDataCollectionByAgentIdsRequest other = (StopDataCollectionByAgentIdsRequest)((Object)obj);
        return Objects.equals(this.agentIds(), other.agentIds());
    }

    public String toString() {
        return ToString.builder((String)"StopDataCollectionByAgentIdsRequest").add("AgentIds", this.agentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentIds": {
                return Optional.ofNullable(clazz.cast(this.agentIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopDataCollectionByAgentIdsRequest model) {
            super(model);
            this.agentIds(model.agentIds);
        }

        public final Collection<String> getAgentIds() {
            return this.agentIds;
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String ... agentIds) {
            this.agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopDataCollectionByAgentIdsRequest build() {
            return new StopDataCollectionByAgentIdsRequest(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    CopyableBuilder<Builder, StopDataCollectionByAgentIdsRequest> {
        public Builder agentIds(Collection<String> var1);

        public Builder agentIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

