/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServerNeighborsRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, ListServerNeighborsRequest> {
    private final String configurationId;
    private final Boolean portInformationNeeded;
    private final List<String> neighborConfigurationIds;
    private final Integer maxResults;
    private final String nextToken;

    private ListServerNeighborsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.portInformationNeeded = builder.portInformationNeeded;
        this.neighborConfigurationIds = builder.neighborConfigurationIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public Boolean portInformationNeeded() {
        return this.portInformationNeeded;
    }

    public List<String> neighborConfigurationIds() {
        return this.neighborConfigurationIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portInformationNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.neighborConfigurationIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsRequest)) {
            return false;
        }
        ListServerNeighborsRequest other = (ListServerNeighborsRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.portInformationNeeded(), other.portInformationNeeded()) && Objects.equals(this.neighborConfigurationIds(), other.neighborConfigurationIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListServerNeighborsRequest").add("ConfigurationId", (Object)this.configurationId()).add("PortInformationNeeded", (Object)this.portInformationNeeded()).add("NeighborConfigurationIds", this.neighborConfigurationIds()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "portInformationNeeded": {
                return Optional.ofNullable(clazz.cast(this.portInformationNeeded()));
            }
            case "neighborConfigurationIds": {
                return Optional.ofNullable(clazz.cast(this.neighborConfigurationIds()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String configurationId;
        private Boolean portInformationNeeded;
        private List<String> neighborConfigurationIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsRequest model) {
            super(model);
            this.configurationId(model.configurationId);
            this.portInformationNeeded(model.portInformationNeeded);
            this.neighborConfigurationIds(model.neighborConfigurationIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final Boolean getPortInformationNeeded() {
            return this.portInformationNeeded;
        }

        @Override
        public final Builder portInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
            return this;
        }

        public final void setPortInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
        }

        public final Collection<String> getNeighborConfigurationIds() {
            return this.neighborConfigurationIds;
        }

        @Override
        public final Builder neighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighborConfigurationIds(String ... neighborConfigurationIds) {
            this.neighborConfigurationIds(Arrays.asList(neighborConfigurationIds));
            return this;
        }

        public final void setNeighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServerNeighborsRequest build() {
            return new ListServerNeighborsRequest(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    CopyableBuilder<Builder, ListServerNeighborsRequest> {
        public Builder configurationId(String var1);

        public Builder portInformationNeeded(Boolean var1);

        public Builder neighborConfigurationIds(Collection<String> var1);

        public Builder neighborConfigurationIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

