/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerAgentInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerConnectorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDiscoverySummaryResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, GetDiscoverySummaryResponse> {
    private final Long servers;
    private final Long applications;
    private final Long serversMappedToApplications;
    private final Long serversMappedtoTags;
    private final CustomerAgentInfo agentSummary;
    private final CustomerConnectorInfo connectorSummary;

    private GetDiscoverySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.applications = builder.applications;
        this.serversMappedToApplications = builder.serversMappedToApplications;
        this.serversMappedtoTags = builder.serversMappedtoTags;
        this.agentSummary = builder.agentSummary;
        this.connectorSummary = builder.connectorSummary;
    }

    public Long servers() {
        return this.servers;
    }

    public Long applications() {
        return this.applications;
    }

    public Long serversMappedToApplications() {
        return this.serversMappedToApplications;
    }

    public Long serversMappedtoTags() {
        return this.serversMappedtoTags;
    }

    public CustomerAgentInfo agentSummary() {
        return this.agentSummary;
    }

    public CustomerConnectorInfo connectorSummary() {
        return this.connectorSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        hashCode = 31 * hashCode + Objects.hashCode(this.serversMappedToApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.serversMappedtoTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoverySummaryResponse)) {
            return false;
        }
        GetDiscoverySummaryResponse other = (GetDiscoverySummaryResponse)((Object)obj);
        return Objects.equals(this.servers(), other.servers()) && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.serversMappedToApplications(), other.serversMappedToApplications()) && Objects.equals(this.serversMappedtoTags(), other.serversMappedtoTags()) && Objects.equals(this.agentSummary(), other.agentSummary()) && Objects.equals(this.connectorSummary(), other.connectorSummary());
    }

    public String toString() {
        return ToString.builder((String)"GetDiscoverySummaryResponse").add("Servers", (Object)this.servers()).add("Applications", (Object)this.applications()).add("ServersMappedToApplications", (Object)this.serversMappedToApplications()).add("ServersMappedtoTags", (Object)this.serversMappedtoTags()).add("AgentSummary", (Object)this.agentSummary()).add("ConnectorSummary", (Object)this.connectorSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "servers": {
                return Optional.ofNullable(clazz.cast(this.servers()));
            }
            case "applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "serversMappedToApplications": {
                return Optional.ofNullable(clazz.cast(this.serversMappedToApplications()));
            }
            case "serversMappedtoTags": {
                return Optional.ofNullable(clazz.cast(this.serversMappedtoTags()));
            }
            case "agentSummary": {
                return Optional.ofNullable(clazz.cast(this.agentSummary()));
            }
            case "connectorSummary": {
                return Optional.ofNullable(clazz.cast(this.connectorSummary()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private Long servers;
        private Long applications;
        private Long serversMappedToApplications;
        private Long serversMappedtoTags;
        private CustomerAgentInfo agentSummary;
        private CustomerConnectorInfo connectorSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoverySummaryResponse model) {
            super(model);
            this.servers(model.servers);
            this.applications(model.applications);
            this.serversMappedToApplications(model.serversMappedToApplications);
            this.serversMappedtoTags(model.serversMappedtoTags);
            this.agentSummary(model.agentSummary);
            this.connectorSummary(model.connectorSummary);
        }

        public final Long getServers() {
            return this.servers;
        }

        @Override
        public final Builder servers(Long servers) {
            this.servers = servers;
            return this;
        }

        public final void setServers(Long servers) {
            this.servers = servers;
        }

        public final Long getApplications() {
            return this.applications;
        }

        @Override
        public final Builder applications(Long applications) {
            this.applications = applications;
            return this;
        }

        public final void setApplications(Long applications) {
            this.applications = applications;
        }

        public final Long getServersMappedToApplications() {
            return this.serversMappedToApplications;
        }

        @Override
        public final Builder serversMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
            return this;
        }

        public final void setServersMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
        }

        public final Long getServersMappedtoTags() {
            return this.serversMappedtoTags;
        }

        @Override
        public final Builder serversMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
            return this;
        }

        public final void setServersMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
        }

        public final CustomerAgentInfo.Builder getAgentSummary() {
            return this.agentSummary != null ? this.agentSummary.toBuilder() : null;
        }

        @Override
        public final Builder agentSummary(CustomerAgentInfo agentSummary) {
            this.agentSummary = agentSummary;
            return this;
        }

        public final void setAgentSummary(CustomerAgentInfo.BuilderImpl agentSummary) {
            this.agentSummary = agentSummary != null ? agentSummary.build() : null;
        }

        public final CustomerConnectorInfo.Builder getConnectorSummary() {
            return this.connectorSummary != null ? this.connectorSummary.toBuilder() : null;
        }

        @Override
        public final Builder connectorSummary(CustomerConnectorInfo connectorSummary) {
            this.connectorSummary = connectorSummary;
            return this;
        }

        public final void setConnectorSummary(CustomerConnectorInfo.BuilderImpl connectorSummary) {
            this.connectorSummary = connectorSummary != null ? connectorSummary.build() : null;
        }

        @Override
        public GetDiscoverySummaryResponse build() {
            return new GetDiscoverySummaryResponse(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    CopyableBuilder<Builder, GetDiscoverySummaryResponse> {
        public Builder servers(Long var1);

        public Builder applications(Long var1);

        public Builder serversMappedToApplications(Long var1);

        public Builder serversMappedtoTags(Long var1);

        public Builder agentSummary(CustomerAgentInfo var1);

        default public Builder agentSummary(Consumer<CustomerAgentInfo.Builder> agentSummary) {
            return this.agentSummary((CustomerAgentInfo)((CustomerAgentInfo.Builder)CustomerAgentInfo.builder().applyMutation(agentSummary)).build());
        }

        public Builder connectorSummary(CustomerConnectorInfo var1);

        default public Builder connectorSummary(Consumer<CustomerConnectorInfo.Builder> connectorSummary) {
            return this.connectorSummary((CustomerConnectorInfo)((CustomerConnectorInfo.Builder)CustomerConnectorInfo.builder().applyMutation(connectorSummary)).build());
        }
    }
}

