/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportsInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportConfigurationsResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, DescribeExportConfigurationsResponse> {
    private final List<ExportInfo> exportsInfo;
    private final String nextToken;

    private DescribeExportConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.exportsInfo = builder.exportsInfo;
        this.nextToken = builder.nextToken;
    }

    public List<ExportInfo> exportsInfo() {
        return this.exportsInfo;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportConfigurationsResponse)) {
            return false;
        }
        DescribeExportConfigurationsResponse other = (DescribeExportConfigurationsResponse)((Object)obj);
        return Objects.equals(this.exportsInfo(), other.exportsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeExportConfigurationsResponse").add("ExportsInfo", this.exportsInfo()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportsInfo": {
                return Optional.ofNullable(clazz.cast(this.exportsInfo()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<ExportInfo> exportsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportConfigurationsResponse model) {
            super(model);
            this.exportsInfo(model.exportsInfo);
            this.nextToken(model.nextToken);
        }

        public final Collection<ExportInfo.Builder> getExportsInfo() {
            return this.exportsInfo != null ? (Collection)this.exportsInfo.stream().map(ExportInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportsInfo(Collection<ExportInfo> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copy(exportsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(ExportInfo ... exportsInfo) {
            this.exportsInfo(Arrays.asList(exportsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(Consumer<ExportInfo.Builder> ... exportsInfo) {
            this.exportsInfo(Stream.of(exportsInfo).map(c -> (ExportInfo)((ExportInfo.Builder)ExportInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportsInfo(Collection<ExportInfo.BuilderImpl> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copyFromBuilder(exportsInfo);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportConfigurationsResponse build() {
            return new DescribeExportConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    CopyableBuilder<Builder, DescribeExportConfigurationsResponse> {
        public Builder exportsInfo(Collection<ExportInfo> var1);

        public Builder exportsInfo(ExportInfo ... var1);

        public Builder exportsInfo(Consumer<ExportInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

