/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConfigurationItemType {
    SERVER("SERVER"),
    PROCESS("PROCESS"),
    CONNECTION("CONNECTION"),
    APPLICATION("APPLICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConfigurationItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConfigurationItemType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationItemType> knownValues() {
        return Stream.of(ConfigurationItemType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

