/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateConfigurationItemsToApplicationRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, AssociateConfigurationItemsToApplicationRequest> {
    private final String applicationConfigurationId;
    private final List<String> configurationIds;

    private AssociateConfigurationItemsToApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationConfigurationId = builder.applicationConfigurationId;
        this.configurationIds = builder.configurationIds;
    }

    public String applicationConfigurationId() {
        return this.applicationConfigurationId;
    }

    public List<String> configurationIds() {
        return this.configurationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateConfigurationItemsToApplicationRequest)) {
            return false;
        }
        AssociateConfigurationItemsToApplicationRequest other = (AssociateConfigurationItemsToApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationConfigurationId(), other.applicationConfigurationId()) && Objects.equals(this.configurationIds(), other.configurationIds());
    }

    public String toString() {
        return ToString.builder((String)"AssociateConfigurationItemsToApplicationRequest").add("ApplicationConfigurationId", (Object)this.applicationConfigurationId()).add("ConfigurationIds", this.configurationIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationId()));
            }
            case "configurationIds": {
                return Optional.ofNullable(clazz.cast(this.configurationIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String applicationConfigurationId;
        private List<String> configurationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateConfigurationItemsToApplicationRequest model) {
            super(model);
            this.applicationConfigurationId(model.applicationConfigurationId);
            this.configurationIds(model.configurationIds);
        }

        public final String getApplicationConfigurationId() {
            return this.applicationConfigurationId;
        }

        @Override
        public final Builder applicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
            return this;
        }

        public final void setApplicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
        }

        public final Collection<String> getConfigurationIds() {
            return this.configurationIds;
        }

        @Override
        public final Builder configurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationIds(String ... configurationIds) {
            this.configurationIds(Arrays.asList(configurationIds));
            return this;
        }

        public final void setConfigurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateConfigurationItemsToApplicationRequest build() {
            return new AssociateConfigurationItemsToApplicationRequest(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    CopyableBuilder<Builder, AssociateConfigurationItemsToApplicationRequest> {
        public Builder applicationConfigurationId(String var1);

        public Builder configurationIds(Collection<String> var1);

        public Builder configurationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

