/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerClient;
import software.amazon.awssdk.services.applicationcostprofiler.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition;

public class ListReportDefinitionsIterable
implements SdkIterable<ListReportDefinitionsResponse> {
    private final ApplicationCostProfilerClient client;
    private final ListReportDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportDefinitionsIterable(ApplicationCostProfilerClient client, ListReportDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportDefinitionsResponseFetcher();
    }

    public Iterator<ListReportDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReportDefinition> reportDefinitions() {
        Function<ListReportDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportDefinitions() != null) {
                return response.reportDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReportDefinitionsResponseFetcher
    implements SyncPageFetcher<ListReportDefinitionsResponse> {
        private ListReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportDefinitionsResponse nextPage(ListReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListReportDefinitionsIterable.this.client.listReportDefinitions(ListReportDefinitionsIterable.this.firstRequest);
            }
            return ListReportDefinitionsIterable.this.client.listReportDefinitions((ListReportDefinitionsRequest)((Object)ListReportDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

