/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerAsyncClient;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition;

public class ListReportDefinitionsPublisher
implements SdkPublisher<ListReportDefinitionsResponse> {
    private final ApplicationCostProfilerAsyncClient client;
    private final ListReportDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportDefinitionsPublisher(ApplicationCostProfilerAsyncClient client, ListReportDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportDefinitionsPublisher(ApplicationCostProfilerAsyncClient client, ListReportDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReportDefinition> reportDefinitions() {
        Function<ListReportDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportDefinitions() != null) {
                return response.reportDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReportDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReportDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListReportDefinitionsResponse> {
        private ListReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportDefinitionsResponse> nextPage(ListReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListReportDefinitionsPublisher.this.client.listReportDefinitions(ListReportDefinitionsPublisher.this.firstRequest);
            }
            return ListReportDefinitionsPublisher.this.client.listReportDefinitions((ListReportDefinitionsRequest)((Object)ListReportDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

