/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction;

public class DescribeScheduledActionsPublisher
implements SdkPublisher<DescribeScheduledActionsResponse> {
    private final ApplicationAutoScalingAsyncClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScheduledActionsPublisher(ApplicationAutoScalingAsyncClient client, DescribeScheduledActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScheduledActionsPublisher(ApplicationAutoScalingAsyncClient client, DescribeScheduledActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduledActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledAction> scheduledActions() {
        return this.flatMapIterable(response -> response.scheduledActions());
    }

    private class DescribeScheduledActionsResponseFetcher
    implements AsyncPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScheduledActionsResponse> nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsPublisher.this.client.describeScheduledActions(DescribeScheduledActionsPublisher.this.firstRequest);
            }
            return DescribeScheduledActionsPublisher.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

