/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalableTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalableTarget> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalableTarget.getter(ScalableTarget::serviceNamespaceAsString)).setter(ScalableTarget.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalableTarget.getter(ScalableTarget::resourceId)).setter(ScalableTarget.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalableTarget.getter(ScalableTarget::scalableDimensionAsString)).setter(ScalableTarget.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(ScalableTarget.getter(ScalableTarget::minCapacity)).setter(ScalableTarget.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(ScalableTarget.getter(ScalableTarget::maxCapacity)).setter(ScalableTarget.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(ScalableTarget.getter(ScalableTarget::roleARN)).setter(ScalableTarget.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScalableTarget.getter(ScalableTarget::creationTime)).setter(ScalableTarget.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<SuspendedState> SUSPENDED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SuspendedState").getter(ScalableTarget.getter(ScalableTarget::suspendedState)).setter(ScalableTarget.setter(Builder::suspendedState)).constructor(SuspendedState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedState").build()}).build();
    private static final SdkField<String> SCALABLE_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableTargetARN").getter(ScalableTarget.getter(ScalableTarget::scalableTargetARN)).setter(ScalableTarget.setter(Builder::scalableTargetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargetARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, SUSPENDED_STATE_FIELD, SCALABLE_TARGET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final String roleARN;
    private final Instant creationTime;
    private final SuspendedState suspendedState;
    private final String scalableTargetARN;

    private ScalableTarget(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.roleARN = builder.roleARN;
        this.creationTime = builder.creationTime;
        this.suspendedState = builder.suspendedState;
        this.scalableTargetARN = builder.scalableTargetARN;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final Integer minCapacity() {
        return this.minCapacity;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SuspendedState suspendedState() {
        return this.suspendedState;
    }

    public final String scalableTargetARN() {
        return this.scalableTargetARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendedState());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableTargetARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalableTarget)) {
            return false;
        }
        ScalableTarget other = (ScalableTarget)obj;
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.suspendedState(), other.suspendedState()) && Objects.equals(this.scalableTargetARN(), other.scalableTargetARN());
    }

    public final String toString() {
        return ToString.builder((String)"ScalableTarget").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("RoleARN", (Object)this.roleARN()).add("CreationTime", (Object)this.creationTime()).add("SuspendedState", (Object)this.suspendedState()).add("ScalableTargetARN", (Object)this.scalableTargetARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SuspendedState": {
                return Optional.ofNullable(clazz.cast(this.suspendedState()));
            }
            case "ScalableTargetARN": {
                return Optional.ofNullable(clazz.cast(this.scalableTargetARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalableTarget, T> g) {
        return obj -> g.apply((ScalableTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer minCapacity;
        private Integer maxCapacity;
        private String roleARN;
        private Instant creationTime;
        private SuspendedState suspendedState;
        private String scalableTargetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalableTarget model) {
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.roleARN(model.roleARN);
            this.creationTime(model.creationTime);
            this.suspendedState(model.suspendedState);
            this.scalableTargetARN(model.scalableTargetARN);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SuspendedState.Builder getSuspendedState() {
            return this.suspendedState != null ? this.suspendedState.toBuilder() : null;
        }

        public final void setSuspendedState(SuspendedState.BuilderImpl suspendedState) {
            this.suspendedState = suspendedState != null ? suspendedState.build() : null;
        }

        @Override
        public final Builder suspendedState(SuspendedState suspendedState) {
            this.suspendedState = suspendedState;
            return this;
        }

        public final String getScalableTargetARN() {
            return this.scalableTargetARN;
        }

        public final void setScalableTargetARN(String scalableTargetARN) {
            this.scalableTargetARN = scalableTargetARN;
        }

        @Override
        public final Builder scalableTargetARN(String scalableTargetARN) {
            this.scalableTargetARN = scalableTargetARN;
            return this;
        }

        public ScalableTarget build() {
            return new ScalableTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalableTarget> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder roleARN(String var1);

        public Builder creationTime(Instant var1);

        public Builder suspendedState(SuspendedState var1);

        default public Builder suspendedState(Consumer<SuspendedState.Builder> suspendedState) {
            return this.suspendedState((SuspendedState)((SuspendedState.Builder)SuspendedState.builder().applyMutation(suspendedState)).build());
        }

        public Builder scalableTargetARN(String var1);
    }
}

