/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;

public class DescribeScalingActivitiesIterable
implements SdkIterable<DescribeScalingActivitiesResponse> {
    private final ApplicationAutoScalingClient client;
    private final DescribeScalingActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScalingActivitiesIterable(ApplicationAutoScalingClient client, DescribeScalingActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScalingActivitiesResponseFetcher();
    }

    public Iterator<DescribeScalingActivitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScalingActivity> scalingActivities() {
        Function<DescribeScalingActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingActivities() != null) {
                return response.scalingActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScalingActivitiesResponseFetcher
    implements SyncPageFetcher<DescribeScalingActivitiesResponse> {
        private DescribeScalingActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScalingActivitiesResponse nextPage(DescribeScalingActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingActivitiesIterable.this.client.describeScalingActivities(DescribeScalingActivitiesIterable.this.firstRequest);
            }
            return DescribeScalingActivitiesIterable.this.client.describeScalingActivities((DescribeScalingActivitiesRequest)((Object)DescribeScalingActivitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

