/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledActionsResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField
            .<List<ScheduledAction>> builder(MarshallingType.LIST)
            .memberName("ScheduledActions")
            .getter(getter(DescribeScheduledActionsResponse::scheduledActions))
            .setter(setter(Builder::scheduledActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScheduledActionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScheduledAction> scheduledActions;

    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActions = builder.scheduledActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ScheduledActions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasScheduledActions() {
        return scheduledActions != null && !(scheduledActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the scheduled actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScheduledActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the scheduled actions.
     */
    public final List<ScheduledAction> scheduledActions() {
        return scheduledActions;
    }

    /**
     * <p>
     * The token required to get the next set of results. This value is <code>null</code> if there are no more results
     * to return.
     * </p>
     * 
     * @return The token required to get the next set of results. This value is <code>null</code> if there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledActions() ? scheduledActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        return hasScheduledActions() == other.hasScheduledActions()
                && Objects.equals(scheduledActions(), other.scheduledActions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduledActionsResponse")
                .add("ScheduledActions", hasScheduledActions() ? scheduledActions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActions":
            return Optional.ofNullable(clazz.cast(scheduledActions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        Information about the scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(Collection<ScheduledAction> scheduledActions);

        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        Information about the scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(ScheduledAction... scheduledActions);

        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledAction>.Builder} avoiding the need
         * to create one manually via {@link List<ScheduledAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduledActions(List<ScheduledAction>)}.
         * 
         * @param scheduledActions
         *        a consumer that will call methods on {@link List<ScheduledAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledActions(List<ScheduledAction>)
         */
        Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions);

        /**
         * <p>
         * The token required to get the next set of results. This value is <code>null</code> if there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to get the next set of results. This value is <code>null</code> if there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            scheduledActions(model.scheduledActions);
            nextToken(model.nextToken);
        }

        public final Collection<ScheduledAction.Builder> getScheduledActions() {
            if (scheduledActions instanceof SdkAutoConstructList) {
                return null;
            }
            return scheduledActions != null ? scheduledActions.stream().map(ScheduledAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction... scheduledActions) {
            scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions) {
            scheduledActions(Stream.of(scheduledActions).map(c -> ScheduledAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copyFromBuilder(scheduledActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
