/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScheduledActionRequest extends ApplicationAutoScalingRequest implements
        ToCopyableBuilder<PutScheduledActionRequest.Builder, PutScheduledActionRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledActionRequest::serviceNamespaceAsString)).setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledActionRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledActionRequest::scheduledActionName)).setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledActionRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledActionRequest::scalableDimensionAsString)).setter(setter(Builder::scalableDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutScheduledActionRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutScheduledActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<ScalableTargetAction> SCALABLE_TARGET_ACTION_FIELD = SdkField
            .<ScalableTargetAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutScheduledActionRequest::scalableTargetAction)).setter(setter(Builder::scalableTargetAction))
            .constructor(ScalableTargetAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargetAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD,
            SCHEDULE_FIELD, SCHEDULED_ACTION_NAME_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, SCALABLE_TARGET_ACTION_FIELD));

    private final String serviceNamespace;

    private final String schedule;

    private final String scheduledActionName;

    private final String resourceId;

    private final String scalableDimension;

    private final Instant startTime;

    private final Instant endTime;

    private final ScalableTargetAction scalableTargetAction;

    private PutScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.schedule = builder.schedule;
        this.scheduledActionName = builder.scheduledActionName;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.scalableTargetAction = builder.scalableTargetAction;
    }

    /**
     * <p>
     * The namespace of the AWS service that provides the resource. For a resource provided by your own application or
     * service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the AWS service that provides the resource. For a resource provided by your own
     *         application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(serviceNamespace);
    }

    /**
     * <p>
     * The namespace of the AWS service that provides the resource. For a resource provided by your own application or
     * service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the AWS service that provides the resource. For a resource provided by your own
     *         application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public String serviceNamespaceAsString() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The schedule for this action. The following formats are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"
     * </p>
     * </li>
     * <li>
     * <p>
     * Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"
     * </p>
     * </li>
     * <li>
     * <p>
     * Cron expressions - "<code>cron(<i>fields</i>)</code>"
     * </p>
     * </li>
     * </ul>
     * <p>
     * At expressions are useful for one-time schedules. Specify the time in UTC.
     * </p>
     * <p>
     * For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> |
     * <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.
     * </p>
     * <p>
     * For more information about cron expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     * </p>
     * <p>
     * For examples of using these expressions, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html"
     * >Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The schedule for this action. The following formats are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cron expressions - "<code>cron(<i>fields</i>)</code>"
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         At expressions are useful for one-time schedules. Specify the time in UTC.
     *         </p>
     *         <p>
     *         For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> |
     *         <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.
     *         </p>
     *         <p>
     *         For more information about cron expressions, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
     *         >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     *         </p>
     *         <p>
     *         For examples of using these expressions, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html"
     *         >Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     */
    public String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The name of the scheduled action. This name must be unique among all other scheduled actions on the specified
     * scalable target.
     * </p>
     * 
     * @return The name of the scheduled action. This name must be unique among all other scheduled actions on the
     *         specified scalable target.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The identifier of the resource associated with the scheduled action. This string consists of the resource type
     * and unique identifier.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service
     * name. Example: <code>service/default/sample-webapp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot
     * Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
     * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
     * Example: <code>fleet/sample-fleet</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example:
     * <code>table/my-table</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index
     * name. Example: <code>table/my-table/index/my-table-index</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
     * Example: <code>cluster:my-db-cluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
     * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code>
     * from the CloudFormation template stack used to access the resources. The unique identifier is defined by the
     * service provider. More information is available in our <a
     * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using
     * the endpoint ARN. Example:
     * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
     * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
     * Example: <code>keyspace/mykeyspace/table/mytable</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the resource associated with the scheduled action. This string consists of the resource
     *         type and unique identifier.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
     *         service name. Example: <code>service/default/sample-webapp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is
     *         the Spot Fleet request ID. Example:
     *         <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID
     *         and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
     *         name. Example: <code>fleet/sample-fleet</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
     *         Example: <code>table/my-table</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
     *         the index name. Example: <code>table/my-table/index/my-table-index</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
     *         name. Example: <code>cluster:my-db-cluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier
     *         is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Custom resources are not supported with a resource type. This parameter must specify the
     *         <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
     *         identifier is defined by the service provider. More information is available in our <a
     *         href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Comprehend document classification endpoint - The resource type and unique identifier are
     *         specified using the endpoint ARN. Example:
     *         <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is
     *         the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     *         <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table
     *         name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
     *         </p>
     *         </li>
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model
     * endpoint variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension. This string consists of the service namespace, resource type, and scaling
     *         property.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker
     *         model endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(scalableDimension);
    }

    /**
     * <p>
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker model
     * endpoint variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension. This string consists of the service namespace, resource type, and scaling
     *         property.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker
     *         model endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public String scalableDimensionAsString() {
        return scalableDimension;
    }

    /**
     * <p>
     * The date and time for this scheduled action to start.
     * </p>
     * 
     * @return The date and time for this scheduled action to start.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time for the recurring schedule to end.
     * </p>
     * 
     * @return The date and time for the recurring schedule to end.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current
     * capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the
     * current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
     * </p>
     * 
     * @return The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the
     *         current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum
     *         capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to
     *         the maximum capacity.
     */
    public ScalableTargetAction scalableTargetAction() {
        return scalableTargetAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(scalableTargetAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScheduledActionRequest)) {
            return false;
        }
        PutScheduledActionRequest other = (PutScheduledActionRequest) obj;
        return Objects.equals(serviceNamespaceAsString(), other.serviceNamespaceAsString())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(scalableDimensionAsString(), other.scalableDimensionAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(scalableTargetAction(), other.scalableTargetAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutScheduledActionRequest").add("ServiceNamespace", serviceNamespaceAsString())
                .add("Schedule", schedule()).add("ScheduledActionName", scheduledActionName()).add("ResourceId", resourceId())
                .add("ScalableDimension", scalableDimensionAsString()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("ScalableTargetAction", scalableTargetAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespaceAsString()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ScalableDimension":
            return Optional.ofNullable(clazz.cast(scalableDimensionAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ScalableTargetAction":
            return Optional.ofNullable(clazz.cast(scalableTargetAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScheduledActionRequest, T> g) {
        return obj -> g.apply((PutScheduledActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutScheduledActionRequest> {
        /**
         * <p>
         * The namespace of the AWS service that provides the resource. For a resource provided by your own application
         * or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the AWS service that provides the resource. For a resource provided by your own
         *        application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The namespace of the AWS service that provides the resource. For a resource provided by your own application
         * or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the AWS service that provides the resource. For a resource provided by your own
         *        application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(ServiceNamespace serviceNamespace);

        /**
         * <p>
         * The schedule for this action. The following formats are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"
         * </p>
         * </li>
         * <li>
         * <p>
         * Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"
         * </p>
         * </li>
         * <li>
         * <p>
         * Cron expressions - "<code>cron(<i>fields</i>)</code>"
         * </p>
         * </li>
         * </ul>
         * <p>
         * At expressions are useful for one-time schedules. Specify the time in UTC.
         * </p>
         * <p>
         * For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> |
         * <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.
         * </p>
         * <p>
         * For more information about cron expressions, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * <p>
         * For examples of using these expressions, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html"
         * >Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param schedule
         *        The schedule for this action. The following formats are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        At expressions - "<code>at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)</code>"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rate expressions - "<code>rate(<i>value</i> <i>unit</i>)</code>"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cron expressions - "<code>cron(<i>fields</i>)</code>"
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        At expressions are useful for one-time schedules. Specify the time in UTC.
         *        </p>
         *        <p>
         *        For rate expressions, <i>value</i> is a positive integer and <i>unit</i> is <code>minute</code> |
         *        <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>.
         *        </p>
         *        <p>
         *        For more information about cron expressions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         *        Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         *        </p>
         *        <p>
         *        For examples of using these expressions, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html"
         *        >Scheduled Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The name of the scheduled action. This name must be unique among all other scheduled actions on the specified
         * scalable target.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action. This name must be unique among all other scheduled actions on the
         *        specified scalable target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The identifier of the resource associated with the scheduled action. This string consists of the resource
         * type and unique identifier.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
         * service name. Example: <code>service/default/sample-webapp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the
         * Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
         * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
         * Example: <code>fleet/sample-fleet</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>table/my-table</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the
         * index name. Example: <code>table/my-table/index/my-table-index</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:my-db-cluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is
         * the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Custom resources are not supported with a resource type. This parameter must specify the
         * <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
         * identifier is defined by the service provider. More information is available in our <a
         * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified
         * using the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
         * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
         * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>keyspace/mykeyspace/table/mytable</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceId
         *        The identifier of the resource associated with the scheduled action. This string consists of the
         *        resource type and unique identifier.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name
         *        and service name. Example: <code>service/default/sample-webapp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is
         *        the Spot Fleet request ID. Example:
         *        <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster
         *        ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
         *        name. Example: <code>fleet/sample-fleet</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         *        Example: <code>table/my-table</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
         *        the index name. Example: <code>table/my-table/index/my-table-index</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:my-db-cluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon SageMaker endpoint variant - The resource type is <code>variant</code> and the unique
         *        identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Custom resources are not supported with a resource type. This parameter must specify the
         *        <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The
         *        unique identifier is defined by the service provider. More information is available in our <a
         *        href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend document classification endpoint - The resource type and unique identifier are
         *        specified using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier
         *        is the function name with a function version or alias name suffix that is not <code>$LATEST</code>.
         *        Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the
         *        table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker
         * model endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension. This string consists of the service namespace, resource type, and scaling
         *        property.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon
         *        SageMaker model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(String scalableDimension);

        /**
         * <p>
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon SageMaker
         * model endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension. This string consists of the service namespace, resource type, and scaling
         *        property.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an Amazon
         *        SageMaker model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(ScalableDimension scalableDimension);

        /**
         * <p>
         * The date and time for this scheduled action to start.
         * </p>
         * 
         * @param startTime
         *        The date and time for this scheduled action to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time for the recurring schedule to end.
         * </p>
         * 
         * @param endTime
         *        The date and time for the recurring schedule to end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the
         * current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity.
         * If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum
         * capacity.
         * </p>
         * 
         * @param scalableTargetAction
         *        The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if
         *        the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum
         *        capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to
         *        the maximum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalableTargetAction(ScalableTargetAction scalableTargetAction);

        /**
         * <p>
         * The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the
         * current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity.
         * If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum
         * capacity.
         * </p>
         * This is a convenience that creates an instance of the {@link ScalableTargetAction.Builder} avoiding the need
         * to create one manually via {@link ScalableTargetAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScalableTargetAction.Builder#build()} is called immediately and
         * its result is passed to {@link #scalableTargetAction(ScalableTargetAction)}.
         * 
         * @param scalableTargetAction
         *        a consumer that will call methods on {@link ScalableTargetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalableTargetAction(ScalableTargetAction)
         */
        default Builder scalableTargetAction(Consumer<ScalableTargetAction.Builder> scalableTargetAction) {
            return scalableTargetAction(ScalableTargetAction.builder().applyMutation(scalableTargetAction).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationAutoScalingRequest.BuilderImpl implements Builder {
        private String serviceNamespace;

        private String schedule;

        private String scheduledActionName;

        private String resourceId;

        private String scalableDimension;

        private Instant startTime;

        private Instant endTime;

        private ScalableTargetAction scalableTargetAction;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScheduledActionRequest model) {
            super(model);
            serviceNamespace(model.serviceNamespace);
            schedule(model.schedule);
            scheduledActionName(model.scheduledActionName);
            resourceId(model.resourceId);
            scalableDimension(model.scalableDimension);
            startTime(model.startTime);
            endTime(model.endTime);
            scalableTargetAction(model.scalableTargetAction);
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final ScalableTargetAction.Builder getScalableTargetAction() {
            return scalableTargetAction != null ? scalableTargetAction.toBuilder() : null;
        }

        @Override
        public final Builder scalableTargetAction(ScalableTargetAction scalableTargetAction) {
            this.scalableTargetAction = scalableTargetAction;
            return this;
        }

        public final void setScalableTargetAction(ScalableTargetAction.BuilderImpl scalableTargetAction) {
            this.scalableTargetAction = scalableTargetAction != null ? scalableTargetAction.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScheduledActionRequest build() {
            return new PutScheduledActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
