/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalableTargetsResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<DescribeScalableTargetsResponse.Builder, DescribeScalableTargetsResponse> {
    private static final SdkField<List<ScalableTarget>> SCALABLE_TARGETS_FIELD = SdkField
            .<List<ScalableTarget>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScalableTargetsResponse::scalableTargets))
            .setter(setter(Builder::scalableTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalableTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalableTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScalableTargetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScalableTarget> scalableTargets;

    private final String nextToken;

    private DescribeScalableTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.scalableTargets = builder.scalableTargets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ScalableTargets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasScalableTargets() {
        return scalableTargets != null && !(scalableTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scalable targets that match the request parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScalableTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The scalable targets that match the request parameters.
     */
    public List<ScalableTarget> scalableTargets() {
        return scalableTargets;
    }

    /**
     * <p>
     * The token required to get the next set of results. This value is <code>null</code> if there are no more results
     * to return.
     * </p>
     * 
     * @return The token required to get the next set of results. This value is <code>null</code> if there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalableTargets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsResponse)) {
            return false;
        }
        DescribeScalableTargetsResponse other = (DescribeScalableTargetsResponse) obj;
        return Objects.equals(scalableTargets(), other.scalableTargets()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScalableTargetsResponse").add("ScalableTargets", scalableTargets())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalableTargets":
            return Optional.ofNullable(clazz.cast(scalableTargets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalableTargetsResponse, T> g) {
        return obj -> g.apply((DescribeScalableTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalableTargetsResponse> {
        /**
         * <p>
         * The scalable targets that match the request parameters.
         * </p>
         * 
         * @param scalableTargets
         *        The scalable targets that match the request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalableTargets(Collection<ScalableTarget> scalableTargets);

        /**
         * <p>
         * The scalable targets that match the request parameters.
         * </p>
         * 
         * @param scalableTargets
         *        The scalable targets that match the request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalableTargets(ScalableTarget... scalableTargets);

        /**
         * <p>
         * The scalable targets that match the request parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScalableTarget>.Builder} avoiding the need
         * to create one manually via {@link List<ScalableTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScalableTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #scalableTargets(List<ScalableTarget>)}.
         * 
         * @param scalableTargets
         *        a consumer that will call methods on {@link List<ScalableTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalableTargets(List<ScalableTarget>)
         */
        Builder scalableTargets(Consumer<ScalableTarget.Builder>... scalableTargets);

        /**
         * <p>
         * The token required to get the next set of results. This value is <code>null</code> if there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to get the next set of results. This value is <code>null</code> if there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private List<ScalableTarget> scalableTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsResponse model) {
            super(model);
            scalableTargets(model.scalableTargets);
            nextToken(model.nextToken);
        }

        public final Collection<ScalableTarget.Builder> getScalableTargets() {
            return scalableTargets != null ? scalableTargets.stream().map(ScalableTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scalableTargets(Collection<ScalableTarget> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copy(scalableTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(ScalableTarget... scalableTargets) {
            scalableTargets(Arrays.asList(scalableTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalableTargets(Consumer<ScalableTarget.Builder>... scalableTargets) {
            scalableTargets(Stream.of(scalableTargets).map(c -> ScalableTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScalableTargets(Collection<ScalableTarget.BuilderImpl> scalableTargets) {
            this.scalableTargets = ScalableTargetsCopier.copyFromBuilder(scalableTargets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalableTargetsResponse build() {
            return new DescribeScalableTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
