/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig;
import software.amazon.awssdk.services.appintegrations.model.PermissionListCopier;
import software.amazon.awssdk.services.appintegrations.model.Publication;
import software.amazon.awssdk.services.appintegrations.model.PublicationListCopier;
import software.amazon.awssdk.services.appintegrations.model.Subscription;
import software.amazon.awssdk.services.appintegrations.model.SubscriptionListCopier;
import software.amazon.awssdk.services.appintegrations.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends AppIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApplicationRequest.getter(CreateApplicationRequest::name)).setter(CreateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(CreateApplicationRequest.getter(CreateApplicationRequest::namespace)).setter(CreateApplicationRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationRequest.getter(CreateApplicationRequest::description)).setter(CreateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ApplicationSourceConfig> APPLICATION_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSourceConfig").getter(CreateApplicationRequest.getter(CreateApplicationRequest::applicationSourceConfig)).setter(CreateApplicationRequest.setter(Builder::applicationSourceConfig)).constructor(ApplicationSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceConfig").build()}).build();
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscriptions").getter(CreateApplicationRequest.getter(CreateApplicationRequest::subscriptions)).setter(CreateApplicationRequest.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Publication>> PUBLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Publications").getter(CreateApplicationRequest.getter(CreateApplicationRequest::publications)).setter(CreateApplicationRequest.setter(Builder::publications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Publication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateApplicationRequest.getter(CreateApplicationRequest::clientToken)).setter(CreateApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateApplicationRequest.getter(CreateApplicationRequest::permissions)).setter(CreateApplicationRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMESPACE_FIELD, DESCRIPTION_FIELD, APPLICATION_SOURCE_CONFIG_FIELD, SUBSCRIPTIONS_FIELD, PUBLICATIONS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String namespace;
    private final String description;
    private final ApplicationSourceConfig applicationSourceConfig;
    private final List<Subscription> subscriptions;
    private final List<Publication> publications;
    private final String clientToken;
    private final Map<String, String> tags;
    private final List<String> permissions;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.description = builder.description;
        this.applicationSourceConfig = builder.applicationSourceConfig;
        this.subscriptions = builder.subscriptions;
        this.publications = builder.publications;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.permissions = builder.permissions;
    }

    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String description() {
        return this.description;
    }

    public final ApplicationSourceConfig applicationSourceConfig() {
        return this.applicationSourceConfig;
    }

    @Deprecated
    public final boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    @Deprecated
    public final boolean hasPublications() {
        return this.publications != null && !(this.publications instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Publication> publications() {
        return this.publications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublications() ? this.publications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.applicationSourceConfig(), other.applicationSourceConfig()) && this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && this.hasPublications() == other.hasPublications() && Objects.equals(this.publications(), other.publications()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Name", (Object)this.name()).add("Namespace", (Object)this.namespace()).add("Description", (Object)this.description()).add("ApplicationSourceConfig", (Object)this.applicationSourceConfig()).add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("Publications", this.hasPublications() ? this.publications() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("Permissions", this.hasPermissions() ? this.permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApplicationSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.applicationSourceConfig()));
            }
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "Publications": {
                return Optional.ofNullable(clazz.cast(this.publications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationSourceConfig", APPLICATION_SOURCE_CONFIG_FIELD);
        map.put("Subscriptions", SUBSCRIPTIONS_FIELD);
        map.put("Publications", PUBLICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String namespace;
        private String description;
        private ApplicationSourceConfig applicationSourceConfig;
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private List<Publication> publications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.name(model.name);
            this.namespace(model.namespace);
            this.description(model.description);
            this.applicationSourceConfig(model.applicationSourceConfig);
            this.subscriptions(model.subscriptions);
            this.publications(model.publications);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.permissions(model.permissions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationSourceConfig.Builder getApplicationSourceConfig() {
            return this.applicationSourceConfig != null ? this.applicationSourceConfig.toBuilder() : null;
        }

        public final void setApplicationSourceConfig(ApplicationSourceConfig.BuilderImpl applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig != null ? applicationSourceConfig.build() : null;
        }

        @Override
        public final Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig;
            return this;
        }

        @Deprecated
        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Deprecated
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Publication.Builder> getPublications() {
            List<Publication.Builder> result = PublicationListCopier.copyToBuilder(this.publications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setPublications(Collection<Publication.BuilderImpl> publications) {
            this.publications = PublicationListCopier.copyFromBuilder(publications);
        }

        @Override
        @Deprecated
        public final Builder publications(Collection<Publication> publications) {
            this.publications = PublicationListCopier.copy(publications);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Publication ... publications) {
            this.publications(Arrays.asList(publications));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Consumer<Publication.Builder> ... publications) {
            this.publications(Stream.of(publications).map(c -> (Publication)((Publication.Builder)Publication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder name(String var1);

        public Builder namespace(String var1);

        public Builder description(String var1);

        public Builder applicationSourceConfig(ApplicationSourceConfig var1);

        default public Builder applicationSourceConfig(Consumer<ApplicationSourceConfig.Builder> applicationSourceConfig) {
            return this.applicationSourceConfig((ApplicationSourceConfig)((ApplicationSourceConfig.Builder)ApplicationSourceConfig.builder().applyMutation(applicationSourceConfig)).build());
        }

        @Deprecated
        public Builder subscriptions(Collection<Subscription> var1);

        @Deprecated
        public Builder subscriptions(Subscription ... var1);

        @Deprecated
        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        @Deprecated
        public Builder publications(Collection<Publication> var1);

        @Deprecated
        public Builder publications(Publication ... var1);

        @Deprecated
        public Builder publications(Consumer<Publication.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

