/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig;
import software.amazon.awssdk.services.appintegrations.model.PermissionListCopier;
import software.amazon.awssdk.services.appintegrations.model.Publication;
import software.amazon.awssdk.services.appintegrations.model.PublicationListCopier;
import software.amazon.awssdk.services.appintegrations.model.Subscription;
import software.amazon.awssdk.services.appintegrations.model.SubscriptionListCopier;
import software.amazon.awssdk.services.appintegrations.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationResponse
extends AppIntegrationsResponse
implements ToCopyableBuilder<Builder, GetApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetApplicationResponse.getter(GetApplicationResponse::arn)).setter(GetApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetApplicationResponse.getter(GetApplicationResponse::id)).setter(GetApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetApplicationResponse.getter(GetApplicationResponse::name)).setter(GetApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetApplicationResponse.getter(GetApplicationResponse::namespace)).setter(GetApplicationResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetApplicationResponse.getter(GetApplicationResponse::description)).setter(GetApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ApplicationSourceConfig> APPLICATION_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSourceConfig").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationSourceConfig)).setter(GetApplicationResponse.setter(Builder::applicationSourceConfig)).constructor(ApplicationSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceConfig").build()}).build();
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscriptions").getter(GetApplicationResponse.getter(GetApplicationResponse::subscriptions)).setter(GetApplicationResponse.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Publication>> PUBLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Publications").getter(GetApplicationResponse.getter(GetApplicationResponse::publications)).setter(GetApplicationResponse.setter(Builder::publications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Publication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(GetApplicationResponse.getter(GetApplicationResponse::createdTime)).setter(GetApplicationResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(GetApplicationResponse.getter(GetApplicationResponse::lastModifiedTime)).setter(GetApplicationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetApplicationResponse.getter(GetApplicationResponse::tags)).setter(GetApplicationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(GetApplicationResponse.getter(GetApplicationResponse::permissions)).setter(GetApplicationResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, NAMESPACE_FIELD, DESCRIPTION_FIELD, APPLICATION_SOURCE_CONFIG_FIELD, SUBSCRIPTIONS_FIELD, PUBLICATIONS_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TAGS_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final String name;
    private final String namespace;
    private final String description;
    private final ApplicationSourceConfig applicationSourceConfig;
    private final List<Subscription> subscriptions;
    private final List<Publication> publications;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final Map<String, String> tags;
    private final List<String> permissions;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.description = builder.description;
        this.applicationSourceConfig = builder.applicationSourceConfig;
        this.subscriptions = builder.subscriptions;
        this.publications = builder.publications;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
        this.permissions = builder.permissions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String description() {
        return this.description;
    }

    public final ApplicationSourceConfig applicationSourceConfig() {
        return this.applicationSourceConfig;
    }

    @Deprecated
    public final boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    @Deprecated
    public final boolean hasPublications() {
        return this.publications != null && !(this.publications instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Publication> publications() {
        return this.publications;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublications() ? this.publications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.applicationSourceConfig(), other.applicationSourceConfig()) && this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && this.hasPublications() == other.hasPublications() && Objects.equals(this.publications(), other.publications()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Namespace", (Object)this.namespace()).add("Description", (Object)this.description()).add("ApplicationSourceConfig", (Object)this.applicationSourceConfig()).add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("Publications", this.hasPublications() ? this.publications() : null).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Tags", this.hasTags() ? this.tags() : null).add("Permissions", this.hasPermissions() ? this.permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApplicationSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.applicationSourceConfig()));
            }
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "Publications": {
                return Optional.ofNullable(clazz.cast(this.publications()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationSourceConfig", APPLICATION_SOURCE_CONFIG_FIELD);
        map.put("Subscriptions", SUBSCRIPTIONS_FIELD);
        map.put("Publications", PUBLICATIONS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String namespace;
        private String description;
        private ApplicationSourceConfig applicationSourceConfig;
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private List<Publication> publications = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant lastModifiedTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.namespace(model.namespace);
            this.description(model.description);
            this.applicationSourceConfig(model.applicationSourceConfig);
            this.subscriptions(model.subscriptions);
            this.publications(model.publications);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.tags(model.tags);
            this.permissions(model.permissions);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApplicationSourceConfig.Builder getApplicationSourceConfig() {
            return this.applicationSourceConfig != null ? this.applicationSourceConfig.toBuilder() : null;
        }

        public final void setApplicationSourceConfig(ApplicationSourceConfig.BuilderImpl applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig != null ? applicationSourceConfig.build() : null;
        }

        @Override
        public final Builder applicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
            this.applicationSourceConfig = applicationSourceConfig;
            return this;
        }

        @Deprecated
        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Deprecated
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<Publication.Builder> getPublications() {
            List<Publication.Builder> result = PublicationListCopier.copyToBuilder(this.publications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setPublications(Collection<Publication.BuilderImpl> publications) {
            this.publications = PublicationListCopier.copyFromBuilder(publications);
        }

        @Override
        @Deprecated
        public final Builder publications(Collection<Publication> publications) {
            this.publications = PublicationListCopier.copy(publications);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Publication ... publications) {
            this.publications(Arrays.asList(publications));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder publications(Consumer<Publication.Builder> ... publications) {
            this.publications(Stream.of(publications).map(c -> (Publication)((Publication.Builder)Publication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder namespace(String var1);

        public Builder description(String var1);

        public Builder applicationSourceConfig(ApplicationSourceConfig var1);

        default public Builder applicationSourceConfig(Consumer<ApplicationSourceConfig.Builder> applicationSourceConfig) {
            return this.applicationSourceConfig((ApplicationSourceConfig)((ApplicationSourceConfig.Builder)ApplicationSourceConfig.builder().applyMutation(applicationSourceConfig)).build());
        }

        @Deprecated
        public Builder subscriptions(Collection<Subscription> var1);

        @Deprecated
        public Builder subscriptions(Subscription ... var1);

        @Deprecated
        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        @Deprecated
        public Builder publications(Collection<Publication> var1);

        @Deprecated
        public Builder publications(Publication ... var1);

        @Deprecated
        public Builder publications(Consumer<Publication.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);
    }
}

